/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import io.github.prospector.modmenu.gui.AlwaysSelectedEntryListWidget;
import io.github.prospector.modmenu.gui.ModListScreen;
import io.github.prospector.modmenu.gui.ModListWidget;
import io.github.prospector.modmenu.util.BadgeRenderer;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.RenderUtils;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.tessellator.Tessellator;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModListEntry
extends AlwaysSelectedEntryListWidget.Entry<ModListEntry> {
    public static final String UNKNOWN_ICON = "/gui/unknown_pack.png";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"modmenu");
    protected final Minecraft client;
    protected final ModContainer container;
    protected final ModMetadata metadata;
    protected final ModListWidget list;
    protected Integer iconLocation;

    public ModListEntry(Minecraft client, ModContainer container, ModListWidget list) {
        this.container = container;
        this.list = list;
        this.metadata = container.getMetadata();
        this.client = client;
    }

    @Override
    public void render(int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        int offsetX = this.getXOffset();
        rowWidth -= offsetX;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindIconTexture();
        ModListEntry.drawIconQuad(rowLeft += offsetX, rowTop);
        String displayName = this.getDisplayName();
        displayName = HardcodedUtil.formatFabricModuleName(displayName);
        Font font = this.client.font;
        int maxNameWidth = rowWidth - 32 - 3;
        String trimmedName = ModListScreen.getString(font, displayName, maxNameWidth);
        int nameX = rowLeft + 32 + 3;
        int nameY = rowTop + 1;
        font.drawString(trimmedName, nameX, nameY, 0xFFFFFF);
        int badgeStartX = nameX + font.getStringWidth(trimmedName) + 2;
        new BadgeRenderer(this.client, badgeStartX, rowTop, rowLeft + rowWidth, this.container, this.list.getParent()).draw(mouseX, mouseY);
        String description = this.metadata.getDescription();
        if (description.isEmpty() && HardcodedUtil.getHardcodedDescriptions().containsKey(this.metadata.getId())) {
            description = HardcodedUtil.getHardcodedDescription(this.metadata.getId());
        }
        int descX = nameX + 4;
        int descY = rowTop + 9 + 2;
        int descWidth = rowWidth - 32 - 7;
        RenderUtils.INSTANCE.drawWrappedString(font, description, descX, descY, descWidth, 2, 0x808080);
    }

    private String getDisplayName() {
        String name = this.metadata.getName();
        if ("Minecraft".equals(name)) {
            return "Better than Adventure";
        }
        return name;
    }

    private static void drawIconQuad(int x, int y) {
        GL11.glEnable((int)3042);
        Tessellator tess = Tessellator.instance;
        tess.startDrawingQuads();
        tess.addVertexWithUV((double)x, (double)y, 0.0, 0.0, 0.0);
        tess.addVertexWithUV((double)x, (double)y + 32.0, 0.0, 0.0, 1.0);
        tess.addVertexWithUV((double)x + 32.0, (double)y + 32.0, 0.0, 1.0, 1.0);
        tess.addVertexWithUV((double)x + 32.0, (double)y, 0.0, 1.0, 0.0);
        tess.draw();
        GL11.glDisable((int)3042);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage createIcon() {
        try {
            Path iconPath = this.resolveIconPath();
            if (iconPath == null) {
                return null;
            }
            BufferedImage cached = this.list.getCachedModIcon(iconPath);
            if (cached != null) {
                return cached;
            }
            try (InputStream inputStream = Files.newInputStream(iconPath, new OpenOption[0]);){
                BufferedImage image = ImageIO.read(inputStream);
                if (image == null) {
                    BufferedImage bufferedImage2 = null;
                    return bufferedImage2;
                }
                if (image.getHeight() != image.getWidth()) {
                    throw new IllegalStateException("Must be square icon");
                }
                this.list.cacheModIcon(iconPath, image);
                BufferedImage bufferedImage = image;
                return bufferedImage;
            }
        }
        catch (Exception e) {
            LOGGER.error("Invalid icon for mod {}", (Object)this.metadata.getName(), (Object)e);
            return null;
        }
    }

    private Path resolveIconPath() {
        Path path = this.container.findPath(this.metadata.getIconPath(0).orElse("assets/" + this.metadata.getId() + "/icon.png")).orElse(null);
        if (path != null && Files.exists(path, new LinkOption[0])) {
            return path;
        }
        ModContainer modMenu = (ModContainer)FabricLoader.getInstance().getModContainer("modmenu").orElseThrow(IllegalAccessError::new);
        String basePath = "assets/modmenu/";
        String fallback = HardcodedUtil.getFabricMods().contains(this.metadata.getId()) ? "fabric_icon.png" : ("minecraft".equals(this.metadata.getId()) ? "mc_icon.png" : ("java".equals(this.metadata.getId()) ? "java_icon.png" : "grey_fabric_icon.png"));
        return modMenu.findPath(basePath + fallback).orElse(null);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        this.list.select(this);
    }

    public ModMetadata getMetadata() {
        return this.metadata;
    }

    public void bindIconTexture() {
        if (this.iconLocation == null) {
            BufferedImage icon = this.createIcon();
            this.iconLocation = icon != null ? Integer.valueOf(this.client.textureManager.loadBufferedTexture(icon).id()) : Integer.valueOf(this.client.textureManager.loadTexture(UNKNOWN_ICON).id());
        }
        this.client.textureManager.bindTexture(this.iconLocation.intValue());
    }

    public void deleteTexture() {
        if (this.iconLocation != null) {
            this.client.textureManager.idToTextureMap.remove(this.iconLocation);
            GL11.glDeleteTextures((int)this.iconLocation);
        }
    }

    public int getXOffset() {
        return 0;
    }
}

