/*
 * Decompiled with CFR 0.152.
 */
package b100.natrium.asm.utils;

import b100.utils.interfaces.Condition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class ASMHelper {
    private static Map<Integer, String> opcodeNames = new HashMap<Integer, String>();

    static {
        opcodeNames.put(0, "NOP");
        opcodeNames.put(1, "ACONST_NULL");
        opcodeNames.put(2, "ICONST_M1");
        opcodeNames.put(3, "ICONST_0");
        opcodeNames.put(4, "ICONST_1");
        opcodeNames.put(5, "ICONST_2");
        opcodeNames.put(6, "ICONST_3");
        opcodeNames.put(7, "ICONST_4");
        opcodeNames.put(8, "ICONST_5");
        opcodeNames.put(9, "LCONST_0");
        opcodeNames.put(10, "LCONST_1");
        opcodeNames.put(11, "FCONST_0");
        opcodeNames.put(12, "FCONST_1");
        opcodeNames.put(13, "FCONST_2");
        opcodeNames.put(14, "DCONST_0");
        opcodeNames.put(15, "DCONST_1");
        opcodeNames.put(17, "SIPUSH");
        opcodeNames.put(16, "BIPUSH");
        opcodeNames.put(18, "LDC");
        opcodeNames.put(21, "ILOAD");
        opcodeNames.put(22, "LLOAD");
        opcodeNames.put(23, "FLOAD");
        opcodeNames.put(24, "DLOAD");
        opcodeNames.put(25, "ALOAD");
        opcodeNames.put(54, "ISTORE");
        opcodeNames.put(55, "LSTORE");
        opcodeNames.put(56, "FSTORE");
        opcodeNames.put(57, "DSTORE");
        opcodeNames.put(58, "ASTORE");
        opcodeNames.put(87, "POP");
        opcodeNames.put(88, "POP2");
        opcodeNames.put(89, "DUP");
        opcodeNames.put(90, "DUP_X1");
        opcodeNames.put(91, "DUP_X2");
        opcodeNames.put(92, "DUP2");
        opcodeNames.put(93, "DUP2_X1");
        opcodeNames.put(94, "DUP2_X2");
        opcodeNames.put(95, "SWAP");
        opcodeNames.put(96, "IADD");
        opcodeNames.put(97, "LADD");
        opcodeNames.put(98, "FADD");
        opcodeNames.put(99, "DADD");
        opcodeNames.put(100, "ISUB");
        opcodeNames.put(101, "LSUB");
        opcodeNames.put(102, "FSUB");
        opcodeNames.put(103, "DSUB");
        opcodeNames.put(104, "IMUL");
        opcodeNames.put(105, "LMUL");
        opcodeNames.put(106, "FMUL");
        opcodeNames.put(107, "DMUL");
        opcodeNames.put(108, "IDIV");
        opcodeNames.put(109, "LDIV");
        opcodeNames.put(110, "FDIV");
        opcodeNames.put(111, "DDIV");
        opcodeNames.put(153, "IFEQ");
        opcodeNames.put(154, "IFNE");
        opcodeNames.put(155, "IFLT");
        opcodeNames.put(156, "IFGE");
        opcodeNames.put(157, "IFGT");
        opcodeNames.put(158, "IFLE");
        opcodeNames.put(159, "IF_ICMPEQ");
        opcodeNames.put(160, "IF_ICMPNE");
        opcodeNames.put(161, "IF_ICMPLT");
        opcodeNames.put(162, "IF_ICMPGE");
        opcodeNames.put(163, "IF_ICMPGT");
        opcodeNames.put(164, "IF_ICMPLE");
        opcodeNames.put(165, "IF_ACMPEQ");
        opcodeNames.put(166, "IF_ACMPNE");
        opcodeNames.put(167, "GOTO");
        opcodeNames.put(172, "IRETURN");
        opcodeNames.put(173, "LRETURN");
        opcodeNames.put(174, "FRETURN");
        opcodeNames.put(175, "DRETURN");
        opcodeNames.put(176, "ARETURN");
        opcodeNames.put(177, "RETURN");
        opcodeNames.put(178, "GETSTATIC");
        opcodeNames.put(179, "PUTSTATIC");
        opcodeNames.put(180, "GETFIELD");
        opcodeNames.put(181, "PUTFIELD");
        opcodeNames.put(182, "INVOKEVIRTUAL");
        opcodeNames.put(183, "INVOKESPECIAL");
        opcodeNames.put(184, "INVOKESTATIC");
        opcodeNames.put(185, "INVOKEINTERFACE");
        opcodeNames.put(186, "INVOKEDYNAMIC");
        opcodeNames.put(187, "NEW");
        opcodeNames.put(188, "NEWARRAY");
        opcodeNames.put(192, "CHECKCAST");
    }

    public static String getOpcodeName(int opcode) {
        return opcodeNames.get(opcode);
    }

    public static String getFrameTypeName(int type) {
        if (type == -1) {
            return "F_NEW";
        }
        if (type == 0) {
            return "F_FULL";
        }
        if (type == 1) {
            return "F_APPEND";
        }
        if (type == 2) {
            return "F_CHOP";
        }
        if (type == 3) {
            return "F_SAME";
        }
        if (type == 4) {
            return "F_SAME1";
        }
        return null;
    }

    private static void print(String string) {
        System.out.print(String.valueOf(string) + "\n");
    }

    public static ClassNode getClassNode(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    public static byte[] getBytes(ClassNode classNode) {
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public static MethodNode findMethod(ClassNode classNode, String name, String desc) {
        ArrayList<MethodNode> foundMethods = new ArrayList<MethodNode>();
        for (MethodNode methodNode : classNode.methods) {
            if (name != null && !methodNode.name.equals(name) || desc != null && !methodNode.desc.equals(desc)) continue;
            foundMethods.add(methodNode);
        }
        if (foundMethods.size() != 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("\n\n");
            if (foundMethods.size() < 1) {
                msg.append("Found no methods with name '" + name + "' and descriptor '" + desc + "' in class '" + classNode.name + "'!\n");
            } else {
                msg.append("Found more than one method matching name '" + name + "' and descriptor '" + desc + "' in class '" + classNode.name + "'!\n");
            }
            msg.append('\n');
            msg.append("All methods in class '" + classNode.name + "': \n");
            for (MethodNode method : classNode.methods) {
                msg.append("    ").append(method.name).append(method.desc).append('\n');
            }
            throw new RuntimeException(msg.toString());
        }
        return (MethodNode)foundMethods.get(0);
    }

    public static MethodNode findMethod(ClassNode classNode, Condition<MethodNode> condition) {
        ArrayList<MethodNode> foundMethods = new ArrayList<MethodNode>();
        for (MethodNode methodNode : classNode.methods) {
            if (!condition.isTrue((Object)methodNode)) continue;
            foundMethods.add(methodNode);
        }
        if (foundMethods.size() != 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("\n\n");
            if (foundMethods.size() < 1) {
                msg.append("Found no methods matching condition '" + condition + "' in class '" + classNode.name + "'!\n");
            } else {
                msg.append("Found more than one method matching condition '" + condition + "' in class '" + classNode.name + "'!\n");
            }
            msg.append('\n');
            msg.append("All methods in class '" + classNode.name + "': \n");
            for (MethodNode method : classNode.methods) {
                msg.append("    ").append(method.name).append(method.desc).append('\n');
            }
            throw new RuntimeException(msg.toString());
        }
        return (MethodNode)foundMethods.get(0);
    }

    public static List<AbstractInsnNode> findAllInstructions(InsnList instructions, Condition<AbstractInsnNode> condition) {
        ArrayList<AbstractInsnNode> list = new ArrayList<AbstractInsnNode>();
        AbstractInsnNode instruction = instructions.getFirst();
        do {
            if (!condition.isTrue((Object)instruction)) continue;
            list.add(instruction);
        } while ((instruction = instruction.getNext()) != null);
        return list;
    }

    public static AbstractInsnNode findInstruction(MethodNode method, boolean backwards, Condition<AbstractInsnNode> condition) {
        return ASMHelper.findInstruction(backwards ? method.instructions.getLast() : method.instructions.getFirst(), backwards, condition);
    }

    public static AbstractInsnNode findInstruction(InsnList instructions, boolean backwards, Condition<AbstractInsnNode> condition) {
        return ASMHelper.findInstruction(backwards ? instructions.getLast() : instructions.getFirst(), backwards, condition);
    }

    public static AbstractInsnNode findInstruction(AbstractInsnNode startInstruction, boolean backwards, Condition<AbstractInsnNode> condition) {
        AbstractInsnNode instruction = startInstruction;
        while (instruction != null) {
            if (condition.isTrue((Object)instruction)) {
                return instruction;
            }
            instruction = backwards ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static FieldNode findField(ClassNode classNode, String name) {
        for (FieldNode fieldNode : classNode.fields) {
            if (!fieldNode.name.equals(name)) continue;
            return fieldNode;
        }
        throw new NullPointerException("Field '" + name + "' does not exist in class " + classNode + "!");
    }

    public static void replaceInstruction(MethodNode method, AbstractInsnNode oldInstruction, AbstractInsnNode newInstruction) {
        ASMHelper.replaceInstruction(method.instructions, oldInstruction, newInstruction);
    }

    public static void replaceInstruction(InsnList instructions, AbstractInsnNode oldInstruction, AbstractInsnNode newInstruction) {
        if (!instructions.contains(oldInstruction)) {
            throw new RuntimeException("Can't replace instruction because it's not in list!");
        }
        AbstractInsnNode prev = oldInstruction.getPrevious();
        if (prev != null) {
            instructions.remove(oldInstruction);
            instructions.insert(prev, newInstruction);
            return;
        }
        AbstractInsnNode next = oldInstruction.getNext();
        if (next != null) {
            instructions.remove(oldInstruction);
            instructions.insertBefore(next, newInstruction);
            return;
        }
        throw new RuntimeException("No previous or next instruction!");
    }

    public static Map<Label, String> generateLabelNames(MethodNode methodNode) {
        return ASMHelper.generateLabelNames(methodNode.instructions);
    }

    public static Map<Label, String> generateLabelNames(InsnList instructions) {
        HashSet<Label> labels = new HashSet<Label>();
        ArrayList<Label> labelList = new ArrayList<Label>();
        for (AbstractInsnNode ins : instructions) {
            LabelNode labelNode;
            Label label;
            if (!(ins instanceof LabelNode) || labels.contains(label = (labelNode = (LabelNode)ins).getLabel())) continue;
            labels.add(label);
            labelList.add(label);
        }
        HashMap<Label, String> labelNames = new HashMap<Label, String>();
        int nameCount = 0;
        for (Label label : labelList) {
            labelNames.put(label, ASMHelper.generateLabelName(nameCount++));
        }
        return labelNames;
    }

    private static String generateLabelName(int i) {
        StringBuilder name = new StringBuilder();
        do {
            char c = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(i % 26);
            name.insert(0, c);
        } while ((i = i / 26 - 1) >= 0);
        return name.toString();
    }

    private static String getLabelName(LabelNode labelNode, Map<Label, String> labelNames) {
        Label label = labelNode.getLabel();
        if (labelNames != null && labelNames.get(label) != null) {
            return labelNames.get(label);
        }
        return label.toString();
    }

    public static void printMethod(MethodNode method) {
        Map<Label, String> names = ASMHelper.generateLabelNames(method);
        ASMHelper.print("METHOD: " + method.name);
        ASMHelper.print("  DESC: " + method.desc);
        ASMHelper.print("  MAXLOCAL: " + method.maxLocals);
        ASMHelper.print("  MAXSTACK: " + method.maxStack);
        ASMHelper.print("  ATTRS: " + method.attrs);
        ASMHelper.print("  SIGNATURE: " + method.signature);
        ASMHelper.print("  LOCALVARIABLES: ");
        for (LocalVariableNode node : method.localVariables) {
            System.out.println("    " + node.name + " " + node.desc + " " + node.index + " start " + names.get(node.start.getLabel()) + " end " + names.get(node.end.getLabel()));
        }
        ASMHelper.print("INSTRUCTIONS: ");
        ASMHelper.printInstructions(method, names);
    }

    public static void printInstructions(MethodNode method) {
        ASMHelper.printInstructions(method.instructions, ASMHelper.generateLabelNames(method));
    }

    public static void printInstructions(MethodNode method, Map<Label, String> labelNames) {
        ASMHelper.printInstructions(method.instructions, labelNames);
    }

    public static void printInstructions(InsnList instructions) {
        ASMHelper.printInstructions(instructions, ASMHelper.generateLabelNames(instructions));
    }

    public static void printInstructions(InsnList instructions, Map<Label, String> labelNames) {
        int i = 0;
        while (i < instructions.size()) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction instanceof LabelNode) {
                LabelNode labelNode = (LabelNode)instruction;
                ASMHelper.print(String.valueOf(labelNames.get(labelNode.getLabel())) + ":");
            } else if (!(instruction instanceof LineNumberNode)) {
                ASMHelper.print("  " + ASMHelper.toString(instruction, labelNames));
            }
            ++i;
        }
    }

    public static String toString(AbstractInsnNode instruction) {
        return ASMHelper.toString(instruction, null);
    }

    public static String toString(AbstractInsnNode instruction, Map<Label, String> labelNames) {
        LabelNode node;
        if (instruction == null) {
            return null;
        }
        int opcode = instruction.getOpcode();
        String type = instruction.getClass().getSimpleName();
        String opcodeName = ASMHelper.getOpcodeName(opcode);
        if (opcodeName == null) {
            opcodeName = String.valueOf(opcode);
        }
        type = String.valueOf(opcodeName) + " " + type;
        if (instruction instanceof LabelNode) {
            node = (LabelNode)instruction;
            type = String.valueOf(type) + " " + ASMHelper.getLabelName(node, labelNames);
        }
        if (instruction instanceof FrameNode) {
            node = (FrameNode)instruction;
            type = String.valueOf(type) + " " + ASMHelper.getFrameTypeName(node.type) + " " + node.local + " " + node.stack;
        }
        if (instruction instanceof LineNumberNode) {
            node = (LineNumberNode)instruction;
            type = String.valueOf(type) + " " + node.line;
        }
        if (instruction instanceof TypeInsnNode) {
            node = (TypeInsnNode)instruction;
            type = String.valueOf(type) + " " + node.desc;
        }
        if (instruction instanceof FieldInsnNode) {
            node = (FieldInsnNode)instruction;
            type = String.valueOf(type) + " " + node.owner + " " + node.name + " " + node.desc;
        }
        if (instruction instanceof MethodInsnNode) {
            node = (MethodInsnNode)instruction;
            type = String.valueOf(type) + " " + node.owner + " " + node.name + " " + node.desc;
        }
        if (instruction instanceof LdcInsnNode) {
            node = (LdcInsnNode)instruction;
            type = String.valueOf(type) + " " + node.cst + " (" + node.cst.getClass() + ")";
        }
        if (instruction instanceof IntInsnNode) {
            node = (IntInsnNode)instruction;
            type = String.valueOf(type) + " " + node.operand;
        }
        if (instruction instanceof VarInsnNode) {
            node = (VarInsnNode)instruction;
            type = String.valueOf(type) + " " + node.var;
        }
        if (instruction instanceof JumpInsnNode) {
            node = (JumpInsnNode)instruction;
            type = String.valueOf(type) + " " + ASMHelper.getLabelName(node.label, labelNames);
        }
        return type;
    }
}

