/*
 * Decompiled with CFR 0.152.
 */
package b100.natrium.asm;

import b100.asmloader.ClassTransformer;
import b100.natrium.asm.utils.ASMHelper;
import b100.natrium.asm.utils.FindInstruction;
import b100.natrium.asm.utils.InjectHelper;
import b100.utils.interfaces.Condition;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class Transformers {
    private static String listenerClass = "b100/natrium/asm/Listeners";
    private static InjectHelper injectHelper = new InjectHelper(listenerClass, "b100/natrium/asm/utils/CallbackInfo");
    private static final String GL11 = "org/lwjgl/opengl/GL11";

    private static void replaceClassInstantiation(InsnList instructions, TypeInsnNode newNode, String newClass) {
        MethodInsnNode initNode = (MethodInsnNode)ASMHelper.findInstruction((AbstractInsnNode)newNode, false, (Condition<AbstractInsnNode>)((Condition)n -> FindInstruction.methodInsn(n, typeInsnNode.desc, "<init>", null)));
        newNode.desc = newClass;
        initNode.owner = newClass;
    }

    class MinecraftClientTransformer
    extends ClassTransformer {
        MinecraftClientTransformer() {
        }

        public boolean accepts(String className) {
            return className.equals("net/minecraft/client/Minecraft");
        }

        public void transform(String className, ClassNode classNode) {
            MethodNode startGame = ASMHelper.findMethod(classNode, "startGame", null);
            TypeInsnNode newNode = (TypeInsnNode)ASMHelper.findInstruction(startGame, false, (Condition<AbstractInsnNode>)((Condition)n -> FindInstruction.opcode(n, 187) && FindInstruction.typeInsn(n, "net/minecraft/client/render/terrain/TerrainRendererLegacy")));
            Transformers.replaceClassInstantiation(startGame.instructions, newNode, "b100/natrium/TerrainRendererMultiDrawNatrium");
        }
    }

    class TessellatorTransformer
    extends ClassTransformer {
        TessellatorTransformer() {
        }

        public boolean accepts(String className) {
            return className.equals("net/minecraft/client/render/tessellator/Tessellator");
        }

        public void transform(String className, ClassNode classNode) {
            MethodNode staticInit = ASMHelper.findMethod(classNode, "<clinit>", null);
            TypeInsnNode newNode = (TypeInsnNode)ASMHelper.findInstruction(staticInit, false, (Condition<AbstractInsnNode>)((Condition)n -> FindInstruction.opcode(n, 187) && FindInstruction.typeInsn(n, "net/minecraft/client/render/tessellator/TessellatorStandard")));
            Transformers.replaceClassInstantiation(staticInit.instructions, newNode, "b100/natrium/TessellatorNatrium");
        }
    }
}

