/*
 * Decompiled with CFR 0.152.
 */
package b100.natrium;

import b100.natrium.ChunkRendererMultiDraw;
import b100.natrium.RegionBuffer;
import b100.natrium.RenderList;
import b100.natrium.RenderRegion;
import b100.natrium.TessellatorNatrium;
import b100.natrium.VertexBuffer;
import b100.natrium.VertexConfig;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.client.render.terrain.TerrainRenderer;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class TerrainRendererMultiDrawNatrium
extends TerrainRenderer {
    public final int VERTEX_BUFFER_INITIAL_CAPACITY = 0x4000000;
    public final int RENDER_LIST_INITIAL_CAPACITY = 2048;
    public final int REGION_SIZE = 9;
    public final int MAX_RENDER_PASSES = 2;
    public final boolean DISABLE_REGION_OFFSET = false;
    public VertexBuffer vertexBuffer;
    public RegionBuffer regionBuffer;
    private VertexConfig terrainVertexConfig;
    int[] drawCalls = new int[2];
    private double renderPosX;
    private double renderPosY;
    private double renderPosZ;
    private double prevSortX;
    private double prevSortY;
    private double prevSortZ;

    public TerrainRendererMultiDrawNatrium(Minecraft minecraft) {
        super(minecraft);
        this.vertexBuffer = new VertexBuffer(0x4000000L);
        this.regionBuffer = new RegionBuffer(9);
    }

    public void renderSolidTerrain(float partialTicks) {
        int i = 0;
        while (i < this.drawCalls.length) {
            this.drawCalls[i] = 0;
            ++i;
        }
        ICamera camera = this.mc.activeCamera;
        this.renderPosX = camera.getX(partialTicks);
        this.renderPosY = camera.getY(partialTicks);
        this.renderPosZ = camera.getZ(partialTicks);
        double dX = this.renderPosX - this.prevSortX;
        double dY = this.renderPosY - this.prevSortY;
        double dZ = this.renderPosZ - this.prevSortZ;
        if (dX * dX + dY * dY + dZ * dZ > 16.0) {
            this.prevSortX = this.renderPosX;
            this.prevSortY = this.renderPosY;
            this.prevSortZ = this.renderPosZ;
            int x = MathHelper.floor((double)this.renderPosX);
            int y = MathHelper.floor((double)this.renderPosY);
            int z = MathHelper.floor((double)this.renderPosZ);
            this.mc.renderGlobal.markRenderersForNewPosition(x, y, z);
        }
        if (this.terrainVertexConfig == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-this.renderPosX), (double)(-this.renderPosY), (double)(-this.renderPosZ));
        this.terrainVertexConfig.enableVBO(this.vertexBuffer.getVbo());
        List<RenderRegion> regions = this.regionBuffer.getAllRegions();
        int i2 = 0;
        while (i2 < regions.size()) {
            RenderRegion region = regions.get(i2);
            RenderList renderList = region.renderLists[0];
            if (renderList != null && renderList.size() > 0) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(region.posX << 9), (double)0.0, (double)(region.posZ << 9));
                renderList.draw();
                this.drawCalls[0] = this.drawCalls[0] + 1;
                GL11.glPopMatrix();
            }
            ++i2;
        }
        this.terrainVertexConfig.disable();
        GL11.glPopMatrix();
    }

    public void renderAllLists(int renderPass) {
        List<RenderRegion> regions = this.regionBuffer.getAllRegions();
        int i = 0;
        while (i < regions.size()) {
            RenderRegion region = regions.get(i);
            RenderList renderList = region.renderLists[renderPass];
            if (renderList != null && renderList.size() > 0) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(region.posX << 9), (double)0.0, (double)(region.posZ << 9));
                renderList.draw();
                int n = renderPass;
                this.drawCalls[n] = this.drawCalls[n] + 1;
                GL11.glPopMatrix();
            }
            ++i;
        }
    }

    public void renderTranslucentTerrain(float partialTicks) {
        boolean fancy;
        if (this.terrainVertexConfig == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-this.renderPosX), (double)(-this.renderPosY), (double)(-this.renderPosZ));
        this.terrainVertexConfig.enableVBO(this.vertexBuffer.getVbo());
        boolean bl = fancy = (Integer)this.mc.gameSettings.fancyGraphics.value != 0;
        if (fancy) {
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        }
        this.renderAllLists(1);
        if (fancy) {
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            if (this.drawCalls[1] > 0) {
                this.renderAllLists(1);
            }
        }
        this.terrainVertexConfig.disable();
        GL11.glPopMatrix();
    }

    public void chunkRendered(ChunkRendererMultiDraw chunkRenderer, TessellatorNatrium tessellator, int renderPass) {
        VertexBuffer.Entry entry;
        tessellator.drawing = false;
        VertexConfig config = tessellator.data.config;
        if (this.terrainVertexConfig == null) {
            this.terrainVertexConfig = config.copy();
        } else if (!this.terrainVertexConfig.equals(tessellator.data.config)) {
            List<RenderRegion> allRegions = this.regionBuffer.getAllRegions();
            int i = 0;
            while (i < allRegions.size()) {
                RenderRegion region = allRegions.get(i);
                if (region.hasRenderData()) {
                    VertexConfig.compareThrow(tessellator.data.config, this.terrainVertexConfig);
                }
                this.regionBuffer.remove(region);
                --i;
                ++i;
            }
            this.terrainVertexConfig = config.copy();
        }
        RenderList renderList = this.getOrCreateRenderList(chunkRenderer, renderPass);
        chunkRenderer.renderListEntries[renderPass] = entry = renderList.add(tessellator.data, chunkRenderer.visible);
    }

    public void chunkVisibilityChanged(ChunkRendererMultiDraw chunkRenderer) {
        RenderRegion region = this.getRenderRegionAtBlockPos(chunkRenderer.posX, chunkRenderer.posZ);
        int renderPass = 0;
        while (renderPass < 2) {
            VertexBuffer.Entry entry = chunkRenderer.renderListEntries[renderPass];
            if (entry != null) {
                RenderList renderList = region.renderLists[renderPass];
                if (renderList == null) {
                    throw new NullPointerException("Region " + region + " does not have a render list for render pass " + renderPass + "!");
                }
                renderList.setVisible(entry, chunkRenderer.visible);
            }
            ++renderPass;
        }
    }

    public void chunkDeleted(ChunkRendererMultiDraw chunkRenderer) {
        RenderRegion region = this.getRenderRegionAtBlockPos(chunkRenderer.posX, chunkRenderer.posZ);
        int renderPass = 0;
        while (renderPass < 2) {
            VertexBuffer.Entry entry = chunkRenderer.renderListEntries[renderPass];
            if (entry != null) {
                RenderList renderList = region.renderLists[renderPass];
                if (renderList == null) {
                    throw new NullPointerException("Region " + region + " does not have a render list for render pass " + renderPass + "!");
                }
                renderList.remove(entry);
                chunkRenderer.renderListEntries[renderPass] = null;
            }
            ++renderPass;
        }
    }

    public RenderList getOrCreateRenderList(ChunkRendererMultiDraw chunkRenderer, int renderPass) {
        return this.getOrCreateRenderList(chunkRenderer.posX, chunkRenderer.posZ, renderPass);
    }

    public RenderList getOrCreateRenderList(int posX, int posZ, int renderPass) {
        RenderRegion region = this.regionBuffer.getRegionAtBlockPos(posX, posZ);
        RenderList renderList = region.renderLists[renderPass];
        if (renderList == null) {
            region.renderLists[renderPass] = renderList = new RenderList(this.vertexBuffer, 2048);
        }
        return renderList;
    }

    public ChunkRenderer createChunkRenderer(World world, List<TileEntity> globalRenderableTileEntities, int x, int y, int z, int size, int lists) {
        return new ChunkRendererMultiDraw(this, world, globalRenderableTileEntities, x, y, z, size, lists);
    }

    public RenderRegion getRenderRegionAtBlockPos(int blockX, int blockZ) {
        return this.regionBuffer.getRegionAtBlockPos(blockX, blockZ);
    }

    public int getTotalDrawCalls() {
        int totalDrawCalls = 0;
        int i = 0;
        while (i < this.drawCalls.length) {
            totalDrawCalls += this.drawCalls[i];
            ++i;
        }
        return totalDrawCalls;
    }
}

