/*
 * Decompiled with CFR 0.152.
 */
package dev.joee.vinyl.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class PacketAudioReceived
extends Packet {
    private static final List<Integer> allReceivedFileIds = new ArrayList<Integer>();
    private int fileId;

    public PacketAudioReceived() {
    }

    public void read(DataInputStream dis) throws IOException {
        this.fileId = dis.readInt();
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePacket(PacketHandler packetHandler) {
        if (!EnvironmentHelper.isServerEnvironment()) {
            return;
        }
        List<Integer> list = allReceivedFileIds;
        synchronized (list) {
            allReceivedFileIds.add(this.fileId);
            allReceivedFileIds.notifyAll();
        }
    }

    public int getEstimatedSize() {
        return 4;
    }

    public PacketAudioReceived(int fileId) {
        this.fileId = fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForReceivedFile(int fileId) throws InterruptedException {
        while (true) {
            List<Integer> list = allReceivedFileIds;
            synchronized (list) {
                allReceivedFileIds.wait(200L);
                if (allReceivedFileIds.contains(fileId)) {
                    allReceivedFileIds.remove((Object)fileId);
                    return;
                }
            }
        }
    }
}

