/*
 * Decompiled with CFR 0.152.
 */
package dev.joee.vinyl.item;

import com.mojang.nbt.tags.CompoundTag;
import dev.joee.vinyl.Vinyl;
import dev.joee.vinyl.file.FileManagerClient;
import dev.joee.vinyl.file.FileManagerServer;
import dev.joee.vinyl.gui.ScreenEditRecord;
import dev.joee.vinyl.tileentity.TileEntityVinylPress;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class ItemBlankRecord
extends Item {
    public ItemBlankRecord() {
        super("record.blank", String.format("%s:item/%s", "vinyl", "record.blank"), Vinyl.CONFIG.getItemId("blankRecordId"));
    }

    public CompoundTag getDefaultTag() {
        CompoundTag tag = super.getDefaultTag();
        tag.putString("RecordName", "");
        tag.putString("RecordArtist", "");
        tag.putString("RecordUrl", "");
        tag.putInt("PrimaryColor", 0);
        tag.putInt("SecondaryColor", 0);
        return tag;
    }

    public boolean onUseItemOnBlock(ItemStack stack, Player player, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        if (world.getBlockId(x, y, z) != Vinyl.vinylPress.id()) {
            return false;
        }
        if (world.isClientSide) {
            return true;
        }
        CompoundTag tag = stack.getData();
        String url = tag.getString("RecordUrl");
        if (tag.getString("RecordName").isEmpty() || tag.getString("RecordArtist").isEmpty() || url.isEmpty()) {
            return false;
        }
        world.setBlockWithNotify(x, y, z, Vinyl.vinylPressActive.id());
        TileEntityVinylPress te = (TileEntityVinylPress)world.getTileEntity(x, y, z);
        te.stack = stack.copy();
        te.setChanged();
        stack.consumeItem(player);
        CompletableFuture<String> filePathFuture = EnvironmentHelper.isSinglePlayer() ? this.downloadAudioToClient(url) : this.downloadAudioToServerAndSend(url);
        ((CompletableFuture)filePathFuture.thenAccept(filePath -> {
            Vinyl.LOGGER.info("Finished downloading {}", filePath);
            if (world.getBlockId(x, y, z) != Vinyl.vinylPressActive.id()) {
                return;
            }
            ItemStack newStack = Vinyl.customRecord.getDefaultStack();
            CompoundTag oldData = te.stack.getData();
            CompoundTag newData = newStack.getData();
            newData.putString("RecordName", oldData.getString("RecordName"));
            newData.putString("RecordArtist", oldData.getString("RecordArtist"));
            newData.putString("RecordFilePath", filePath);
            newData.putInt("PrimaryColor", oldData.getInteger("PrimaryColor"));
            newData.putInt("SecondaryColor", oldData.getInteger("SecondaryColor"));
            TileEntityVinylPress.shouldDropContents = false;
            world.setBlockWithNotify(x, y, z, Vinyl.vinylPress.id());
            TileEntityVinylPress newTileEntity = new TileEntityVinylPress(newStack);
            world.setTileEntity(x, y, z, (TileEntity)newTileEntity);
            TileEntityVinylPress.shouldDropContents = true;
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            for (int i = 0; i < 5; ++i) {
                world.spawnParticle("smoke", (double)((float)x - 0.1f), (double)((float)y + 0.5f), (double)((float)z + world.rand.nextFloat()), 0.0, 0.1, 0.0, 0);
                world.spawnParticle("smoke", (double)((float)x + 1.1f), (double)((float)y + 0.5f), (double)((float)z + world.rand.nextFloat()), 0.0, 0.1, 0.0, 0);
                world.spawnParticle("smoke", (double)((float)x + world.rand.nextFloat()), (double)((float)y + 0.5f), (double)((float)z - 0.1f), 0.0, 0.1, 0.0, 0);
                world.spawnParticle("smoke", (double)((float)x + world.rand.nextFloat()), (double)((float)y + 0.5f), (double)((float)z + 1.1f), 0.0, 0.1, 0.0, 0);
            }
        })).exceptionally(e -> {
            Vinyl.LOGGER.warn("Failed to download audio!");
            world.setBlockWithNotify(x, y, z, Vinyl.vinylPress.id());
            return null;
        });
        return true;
    }

    public ItemStack onUseItem(ItemStack stack, World world, Player player) {
        if (!EnvironmentHelper.isServerEnvironment()) {
            int slot = -1;
            for (int i = 0; i < player.inventory.mainInventory.length; ++i) {
                if (player.inventory.mainInventory[i] != stack) continue;
                slot = i;
                break;
            }
            if (slot != -1) {
                this.showEditScreen(stack, slot);
            }
        }
        return super.onUseItem(stack, world, player);
    }

    @Environment(value=EnvType.CLIENT)
    private void showEditScreen(ItemStack stack, int slot) {
        Minecraft.getMinecraft().displayScreen((Screen)new ScreenEditRecord(stack, slot));
    }

    @Environment(value=EnvType.CLIENT)
    private CompletableFuture<String> downloadAudioToClient(String url) {
        return FileManagerClient.instance.downloadAudioFromYtdlp(url);
    }

    @Environment(value=EnvType.SERVER)
    private CompletableFuture<String> downloadAudioToServerAndSend(String url) {
        return FileManagerServer.instance.downloadAudioFromYtdlpAndSend(url);
    }
}

