/*
 * Decompiled with CFR 0.152.
 */
package dev.joee.vinyl.gui;

import com.mojang.nbt.tags.CompoundTag;
import dev.joee.vinyl.network.NetworkMessageModifyRecord;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.core.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

@Environment(value=EnvType.CLIENT)
public class ScreenEditRecord
extends Screen {
    private final ItemElement itemElement;
    private final ItemStack record;
    private final int slot;
    private TextFieldElement recordNameField;
    private TextFieldElement recordArtistField;
    private TextFieldElement recordUrlField;
    private ButtonElement buttonSave;

    public ScreenEditRecord(ItemStack disc, int slot) {
        this.record = disc;
        this.slot = slot;
        Minecraft mc = Minecraft.getMinecraft();
        this.itemElement = new ItemElement(mc);
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttons.clear();
        this.buttonSave = new ButtonElement(0, this.width / 2 - 100, this.height / 2 + 85 - 20, "Save");
        this.buttons.add(this.buttonSave);
        this.buttons.add(new ButtonElement(1, this.width / 2 - 100, this.height / 2 + 85 - 20 + 25, "Cancel"));
        String recordName = this.record.getData().getString("RecordName");
        String recordArtist = this.record.getData().getString("RecordArtist");
        String recordUrl = this.record.getData().getString("RecordUrl");
        int textFieldsWidth = 160;
        this.recordNameField = new TextFieldElement((Screen)this, this.font, this.width / 2 - textFieldsWidth / 2 + 70, this.height / 2 - 10 - 30 - 20, textFieldsWidth, 20, recordName, "Name");
        this.recordArtistField = new TextFieldElement((Screen)this, this.font, this.width / 2 - textFieldsWidth / 2 + 70, this.height / 2 - 10 - 20, textFieldsWidth, 20, recordArtist, "Artist");
        this.recordUrlField = new TextFieldElement((Screen)this, this.font, this.width / 2 - textFieldsWidth / 2 + 70, this.height / 2 - 10 + 30 - 20, textFieldsWidth, 20, recordUrl, "Music URL");
        this.buttonSave.enabled = !this.recordNameField.getText().isEmpty() && !this.recordArtistField.getText().isEmpty() && !this.recordUrlField.getText().isEmpty();
    }

    protected void buttonClicked(ButtonElement button) {
        super.buttonClicked(button);
        if (button.id == 0) {
            CompoundTag tag = this.record.getData();
            tag.putString("RecordName", this.recordNameField.getText());
            tag.putString("RecordArtist", this.recordArtistField.getText());
            tag.putString("RecordUrl", this.recordUrlField.getText());
            if (!EnvironmentHelper.isSinglePlayer()) {
                NetworkHandler.sendToServer((NetworkMessage)new NetworkMessageModifyRecord(this.slot, this.recordNameField.getText(), this.recordArtistField.getText(), this.recordUrlField.getText()));
            }
            this.mc.displayScreen(null);
        } else if (button.id == 1) {
            this.mc.displayScreen(null);
        }
    }

    public void keyPressed(char c, int key, int mouseX, int mouseY) {
        if (key != 14) {
            super.keyPressed(c, key, mouseX, mouseY);
        }
        if (key == 15) {
            if (this.recordNameField.isFocused) {
                this.recordNameField.isFocused = false;
                this.recordArtistField.isFocused = true;
            } else if (this.recordArtistField.isFocused) {
                this.recordArtistField.isFocused = false;
                this.recordUrlField.isFocused = true;
            } else if (this.recordUrlField.isFocused) {
                this.recordUrlField.isFocused = false;
                this.recordNameField.isFocused = true;
            }
        }
        this.recordNameField.textboxKeyTyped(c, key);
        this.recordArtistField.textboxKeyTyped(c, key);
        this.recordUrlField.textboxKeyTyped(c, key);
        boolean bl = this.buttonSave.enabled = !this.recordNameField.getText().isEmpty() && !this.recordArtistField.getText().isEmpty() && !this.recordUrlField.getText().isEmpty();
        if (this.buttonSave.enabled && c == '\r') {
            this.buttonClicked((ButtonElement)this.buttons.get(0));
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.recordNameField.mouseClicked(mouseX, mouseY, mouseButton);
        this.recordArtistField.mouseClicked(mouseX, mouseY, mouseButton);
        this.recordUrlField.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        this.renderBackground();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)this.width * 0.5f - 100.0f), (float)((float)this.height * 0.5f - 20.0f), (float)0.0f);
        GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
        GL11.glTranslatef((float)-7.5f, (float)-8.0f, (float)0.0f);
        this.itemElement.render(this.record, 0, 0);
        GL11.glPopMatrix();
        this.drawStringCentered(this.font, "Customize Disc", this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.recordNameField.drawTextBox();
        this.recordArtistField.drawTextBox();
        this.recordUrlField.drawTextBox();
        super.render(mouseX, mouseY, partialTick);
    }
}

