/*
 * Decompiled with CFR 0.152.
 */
package dev.joee.vinyl.file;

import dev.joee.vinyl.Vinyl;
import dev.joee.vinyl.file.YtdlpFailedException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public abstract class FileManagerBase {
    public abstract File getAudioDir();

    public abstract File getWorldAudioDir();

    public String[] getAudioFilePaths() {
        File musicDir = new File(this.getAudioDir(), "music");
        musicDir.mkdirs();
        return (String[])Arrays.stream(Objects.requireNonNull(musicDir.listFiles())).map(f -> String.format("music/%s", f.getName())).toArray(String[]::new);
    }

    public CompletableFuture<String> downloadAudioFromYtdlp(String url) {
        Process process;
        Vinyl.LOGGER.info("Downloading from {}", (Object)url);
        UUID uuid = UUID.randomUUID();
        String filePath = String.format("music/%s.ogg", uuid);
        File musicDir = new File(this.getWorldAudioDir(), "music");
        musicDir.mkdirs();
        File audioFile = new File(musicDir, String.format("%s.ogg", uuid));
        try {
            process = new ProcessBuilder(new String[0]).command("yt-dlp", "-xf", "worst", "--audio-format", "vorbis", "-o", audioFile.getAbsolutePath().replace(".ogg", ""), url).start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Process finalProcess = process;
        return CompletableFuture.supplyAsync(() -> {
            try {
                finalProcess.waitFor();
                if (finalProcess.exitValue() != 0) {
                    throw new YtdlpFailedException();
                }
                return filePath;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

