/*
 * Decompiled with CFR 0.152.
 */
package dev.joee.vinyl;

import dev.joee.vinyl.Config;
import dev.joee.vinyl.block.BlockLogicVinylPress;
import dev.joee.vinyl.block.BlockLogicVinylPressActive;
import dev.joee.vinyl.item.ItemBlankRecord;
import dev.joee.vinyl.item.ItemCustomRecord;
import dev.joee.vinyl.network.NetworkMessageModifyRecord;
import dev.joee.vinyl.network.NetworkMessagePlayMusic;
import dev.joee.vinyl.network.NetworkMessagePlayNote;
import dev.joee.vinyl.network.PacketAudioChunk;
import dev.joee.vinyl.network.PacketAudioReceived;
import dev.joee.vinyl.network.PacketFileList;
import dev.joee.vinyl.recipe.RecipeEntryBlankDiscDye;
import dev.joee.vinyl.sound.VinylSoundRepository;
import dev.joee.vinyl.tileentity.TileEntityVinylJukebox;
import dev.joee.vinyl.tileentity.TileEntityVinylPress;
import net.fabricmc.api.ModInitializer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.collection.NamespaceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import turniplabs.halplibe.helper.BlockBuilder;
import turniplabs.halplibe.helper.CreativeHelper;
import turniplabs.halplibe.helper.EntityHelper;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.ItemBuilder;
import turniplabs.halplibe.helper.RecipeBuilder;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.util.GameStartEntrypoint;
import turniplabs.halplibe.util.RecipeEntrypoint;

public class Vinyl
implements ModInitializer,
RecipeEntrypoint,
GameStartEntrypoint {
    public static final String MOD_ID = "vinyl";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"vinyl");
    public static final Config CONFIG = new Config();
    public static VinylSoundRepository SOUNDS;
    public static Block<BlockLogicVinylPress> vinylPress;
    public static Block<BlockLogicVinylPressActive> vinylPressActive;
    public static Item blankRecord;
    public static Item customRecord;

    public void onInitialize() {
        LOGGER.info("Vinyl initialized.");
        Packet.addMapping((int)CONFIG.getPacketId("audioChunkId"), (boolean)true, (boolean)false, PacketAudioChunk.class);
        Packet.addMapping((int)CONFIG.getPacketId("fileListId"), (boolean)true, (boolean)true, PacketFileList.class);
        Packet.addMapping((int)CONFIG.getPacketId("audioReceivedId"), (boolean)false, (boolean)true, PacketAudioReceived.class);
        NetworkHandler.registerNetworkMessage(NetworkMessageModifyRecord::new);
        NetworkHandler.registerNetworkMessage(NetworkMessagePlayMusic::new);
        NetworkHandler.registerNetworkMessage(NetworkMessagePlayNote::new);
    }

    public void onRecipesReady() {
    }

    public void initNamespaces() {
        Registries.ITEM_GROUPS.register("vinyl:disc", (Object)Registries.stackListOf((Object[])new Object[]{Items.RECORD_13, Items.RECORD_BLOCKS, Items.RECORD_CAT, Items.RECORD_CHIRP, Items.RECORD_DOG, Items.RECORD_FAR, Items.RECORD_MALL, Items.RECORD_MELLOHI, Items.RECORD_STAL, Items.RECORD_STRAD, Items.RECORD_WAIT, Items.RECORD_WARD, customRecord}));
        RecipeBuilder.Shaped((String)MOD_ID).setShape(new String[]{"SSS", "PDP", "SSS"}).addInput('S', (IItemConvertible)Blocks.BLOCK_STEEL).addInput('P', (IItemConvertible)Blocks.PISTON_BASE_STICKY).addInput('D', "vinyl:disc").create("recordPress", vinylPress.getDefaultStack());
        RecipeBuilder.BlastFurnace((String)MOD_ID).setInput("vinyl:disc").create("blankDisc", blankRecord.getDefaultStack());
        RecipeBuilder.getRecipeGroup((String)MOD_ID, (String)"workbench", (RecipeSymbol)new RecipeSymbol(Blocks.WORKBENCH.getDefaultStack())).register("blankDiscDye", (RecipeEntryBase)new RecipeEntryBlankDiscDye());
    }

    public void beforeGameStart() {
        vinylPress = new BlockBuilder(MOD_ID).setTileEntity(TileEntityVinylPress::new).setHardness(5.0f).setResistance(2000.0f).setTags(new Tag[]{BlockTags.MINEABLE_BY_PICKAXE}).build("vinylPress", CONFIG.getBlockId("vinylPressId"), BlockLogicVinylPress::new);
        vinylPressActive = new BlockBuilder(MOD_ID).setTileEntity(TileEntityVinylPress::new).setLuminance(15).setHardness(5.0f).setResistance(2000.0f).setTags(new Tag[]{BlockTags.MINEABLE_BY_PICKAXE, BlockTags.NOT_IN_CREATIVE_MENU}).build("vinylPressActive", CONFIG.getBlockId("vinylPressActiveId"), BlockLogicVinylPressActive::new);
        blankRecord = new ItemBuilder(MOD_ID).setStackSize(1).build((Item)new ItemBlankRecord());
        customRecord = new ItemBuilder(MOD_ID).setStackSize(1).setTags(new Tag[]{ItemTags.NOT_IN_CREATIVE_MENU}).build((Item)new ItemCustomRecord());
        EntityHelper.createTileEntity(TileEntityVinylPress.class, (NamespaceID)NamespaceID.getPermanent((String)MOD_ID, (String)"vinylPress"));
        EntityHelper.createTileEntity(TileEntityVinylJukebox.class, (NamespaceID)NamespaceID.getPermanent((String)MOD_ID, (String)"vinylJukebox"));
    }

    public void afterGameStart() {
        if (!EnvironmentHelper.isServerEnvironment()) {
            SOUNDS = new VinylSoundRepository();
        }
        CreativeHelper.setParent((IItemConvertible)blankRecord, (IItemConvertible)Items.RECORD_DOG);
    }
}

