/*
 * Decompiled with CFR 0.152.
 */
package xyz.bartkk.betterflags.mixin;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DrawableSurfaceElement;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.render.Font;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.command.TextFormatting;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import xyz.bartkk.betterflags.FlagUtils;
import xyz.bartkk.betterflags.TooltipFlagRenderer;

@Mixin(value={TooltipElement.class}, remap=false)
public abstract class TooltipElementMixin
extends Gui
implements TooltipFlagRenderer {
    @Shadow
    Font fr;
    @Shadow
    Minecraft mc;
    @Unique
    private ItemStack lastItemStack;
    @Unique
    private DrawableSurfaceElement lastDrawableSurfaceElement;

    @Shadow
    protected abstract int[] drawBackground(int var1, int var2, int var3, int var4);

    @Shadow
    public abstract int getPadding();

    @Override
    public void betterflags$renderFlag(String string, int x, int y, int offsetX, int offsetY, ItemStack stack) {
        String[] lines = string.split("\n");
        if (lines.length != 0) {
            int width = 0;
            for (String line : lines) {
                width = Math.max(width, this.fr.getStringWidth(line));
            }
            int flagScale = 2;
            int height = lines.length * 8 + (lines.length - 1) * 3 + 16 * flagScale + this.getPadding();
            if (x + offsetX + width + 6 > this.mc.resolution.getScaledWidthScreenCoords()) {
                offsetX = -offsetX - width;
            }
            offsetY -= Math.max(0, y + height + offsetY + 6 - this.mc.resolution.getScaledHeightScreenCoords());
            int padding = this.getPadding();
            this.drawBackground(x += offsetX, y += offsetY, x + width + padding * 2, y + height + padding * 2);
            for (int i = 0; i < lines.length; ++i) {
                this.fr.drawStringWithShadow(lines[i], x + padding, y + padding + i * 11, 0xFFFFFF);
            }
            y = y + padding + lines.length * 11;
            DrawableSurfaceElement flagSurface = this.getFlagDrawable(stack, flagScale);
            this.mc.textureManager.bindTexture(this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/flag_editor.png"));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect((double)x + (double)padding, y, 27, 8, 48, 16 * flagScale, 96, 64);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)769, (int)768);
            flagSurface.render(x + padding, y);
            GL11.glDisable((int)3042);
        }
    }

    @Unique
    public final DrawableSurfaceElement getFlagDrawable(ItemStack stack, int scale) {
        if (this.lastDrawableSurfaceElement != null && this.lastItemStack == stack) {
            return this.lastDrawableSurfaceElement;
        }
        CompoundTag flagData = stack.getData().getCompound("FlagData");
        byte[] colors = flagData.getByteArray("Colors");
        ListTag items = flagData.getList("Items");
        byte[] unpackedColors = FlagUtils.unpackFlagColors(colors);
        DrawableSurfaceElement flagSurface = new DrawableSurfaceElement(24, 16, scale, unpackedColors);
        int[] dyeColors = new int[5];
        for (int i = 0; i < items.tagCount(); ++i) {
            CompoundTag compound = (CompoundTag)items.tagAt(i);
            byte slot = compound.getByte("Slot");
            ItemStack colorItemStack = ItemStack.readItemStackFromNbt((CompoundTag)compound);
            if (colorItemStack == null || colorItemStack.getItem() != Items.DYE) continue;
            dyeColors[slot + 1] = Colors.allFlagColors[TextFormatting.get((int)(15 - colorItemStack.getMetadata())).id].getARGB();
        }
        dyeColors[4] = -1;
        flagSurface.colors = dyeColors;
        this.lastDrawableSurfaceElement = flagSurface;
        this.lastItemStack = stack;
        return flagSurface;
    }
}

