/*
 * Decompiled with CFR 0.152.
 */
package xyz.bartkk.betterflags.mixin;

import java.util.Base64;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.DrawableSurfaceElement;
import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.client.gui.container.ScreenFlagEditor;
import net.minecraft.client.gui.toasts.IToastable;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.bartkk.betterflags.BetterFlags;
import xyz.bartkk.betterflags.FlagUtils;
import xyz.bartkk.betterflags.SimpleToast;

@Mixin(value={ScreenFlagEditor.class}, remap=false)
public abstract class ScreenFlagEditorMixin
extends ScreenContainerAbstract {
    @Shadow
    @Final
    private TileEntityFlag flagEntity;
    @Shadow
    DrawableSurfaceElement flagSurface;

    public ScreenFlagEditorMixin(MenuAbstract container) {
        super(container);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(Player player, TileEntityFlag flagTileEntity, CallbackInfo ci) {
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        int x = (this.width - this.xSize) / 2 + this.xSize + 8;
        int y = (this.height - this.ySize) / 2;
        this.buttons.add(new ButtonElement(201, x + 18, y + 6, 12, 12, "").setTextures("betterflags:gui/arrow_up", "betterflags:gui/arrow_up_highlighted", "betterflags:gui/arrow_up_disabled"));
        this.buttons.add(new ButtonElement(202, x + 6, y + 18, 12, 12, "").setTextures("betterflags:gui/arrow_left", "betterflags:gui/arrow_left_highlighted", "betterflags:gui/arrow_left_disabled"));
        this.buttons.add(new ButtonElement(203, x + 30, y + 18, 12, 12, "").setTextures("betterflags:gui/arrow_right", "betterflags:gui/arrow_right_highlighted", "betterflags:gui/arrow_right_disabled"));
        this.buttons.add(new ButtonElement(204, x + 18, y + 30, 12, 12, "").setTextures("betterflags:gui/arrow_down", "betterflags:gui/arrow_down_highlighted", "betterflags:gui/arrow_down_disabled"));
        this.buttons.add(new ButtonElement(205, x + 6, y + 62, 36, 12, I18n.getInstance().translateKey("toast.betterflags.clear")));
        this.buttons.add(new ButtonElement(206, x + 6, y + 62 + 16, 36, 12, I18n.getInstance().translateKey("toast.betterflags.copy")));
        this.buttons.add(new ButtonElement(207, x + 6, y + 62 + 16 + 4 + 12, 36, 12, I18n.getInstance().translateKey("toast.betterflags.paste")));
        this.buttons.add(new ButtonElement(208, x + 6, y + 46, 12, 12, "").setTextures("betterflags:gui/horizontal_flip", "betterflags:gui/horizontal_flip_highlighted", "betterflags:gui/horizontal_flip_disabled"));
        this.buttons.add(new ButtonElement(209, x + 30, y + 46, 12, 12, "").setTextures("betterflags:gui/vertical_flip", "betterflags:gui/vertical_flip_highlighted", "betterflags:gui/vertical_flip_disabled"));
    }

    @Inject(method={"drawGuiContainerBackgroundLayer"}, at={@At(value="TAIL")})
    protected void drawGuiContainerBackgroundLayer(float f, CallbackInfo ci) {
        this.mc.textureManager.loadTexture("/assets/betterflags/textures/gui/container/flag_editor_extras.png").bind();
        int j = (this.width - this.xSize) / 2 + this.xSize + 8;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, 48, 112, 1, 1.0f);
    }

    @Inject(method={"buttonClicked"}, at={@At(value="TAIL")})
    protected void buttonClicked(ButtonElement button, CallbackInfo ci) {
        if (button.id == 201) {
            this.move(0, 1);
        } else if (button.id == 202) {
            this.move(-1, 0);
        } else if (button.id == 203) {
            this.move(1, 0);
        } else if (button.id == 204) {
            this.move(0, -1);
        }
        if (button.id == 205) {
            this.flagSurface.clear();
            this.flagEntity.isDirty = true;
        }
        if (button.id == 206) {
            byte[] packed = FlagUtils.packFlagColors(this.flagSurface.surfaceData);
            Base64.Encoder encoder = Base64.getEncoder();
            String base64 = encoder.encodeToString(packed);
            String data = "BTAFLAG_" + base64;
            GLFW.glfwSetClipboardString((long)Minecraft.getMinecraft().gameWindow.getHandle(), (CharSequence)data);
            Minecraft.getMinecraft().guiToasts.addToast((IToastable)new SimpleToast("", I18n.getInstance().translateKey("toast.betterflags.copied")));
        } else if (button.id == 207) {
            byte[] unpacked;
            String clipboard = GLFW.glfwGetClipboardString((long)Minecraft.getMinecraft().gameWindow.getHandle());
            if (clipboard == null) {
                return;
            }
            if (!clipboard.startsWith("BTAFLAG_")) {
                Minecraft.getMinecraft().guiToasts.addToast((IToastable)new SimpleToast("", I18n.getInstance().translateKey("toast.betterflags.invalid_data")));
                return;
            }
            try {
                String base64 = clipboard.substring("BTAFLAG_".length());
                Base64.Decoder decoder = Base64.getDecoder();
                byte[] decoded = decoder.decode(base64);
                unpacked = FlagUtils.unpackFlagColors(decoded);
            }
            catch (RuntimeException e) {
                BetterFlags.LOGGER.error(e.toString());
                Minecraft.getMinecraft().guiToasts.addToast((IToastable)new SimpleToast("", I18n.getInstance().translateKey("toast.betterflags.invalid_data")));
                return;
            }
            if (unpacked.length != 384) {
                Minecraft.getMinecraft().guiToasts.addToast((IToastable)new SimpleToast("", I18n.getInstance().translateKey("toast.betterflags.invalid_data")));
                return;
            }
            System.arraycopy(unpacked, 0, this.flagSurface.surfaceData, 0, unpacked.length);
            this.flagEntity.isDirty = true;
        } else if (button.id == 208) {
            this.horizontalFlip();
        } else if (button.id == 209) {
            this.verticalFlip();
        }
    }

    @Unique
    private void move(int offsetX, int offsetY) {
        int j;
        int i;
        this.flagEntity.isDirty = true;
        int width = this.flagSurface.getWidth();
        int height = this.flagSurface.getHeight();
        byte[] data = new byte[width * height];
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                data[i * width + j] = this.flagSurface.getPixelValue(j, i);
                this.flagSurface.setPixelValue(j, i, Byte.valueOf((byte)0));
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                int y = i - offsetY;
                int x = j + offsetX;
                this.flagSurface.setPixelValue(x, y, Byte.valueOf(data[i * width + j]));
            }
        }
    }

    @Unique
    private void horizontalFlip() {
        int j;
        int i;
        this.flagEntity.isDirty = true;
        int width = this.flagSurface.getWidth();
        int height = this.flagSurface.getHeight();
        byte[] data = new byte[width * height];
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                data[i * width + j] = this.flagSurface.getPixelValue(j, i);
                this.flagSurface.setPixelValue(j, i, Byte.valueOf((byte)0));
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                int y = i;
                int x = width - j - 1;
                this.flagSurface.setPixelValue(x, y, Byte.valueOf(data[i * width + j]));
            }
        }
    }

    @Unique
    private void verticalFlip() {
        int j;
        int i;
        this.flagEntity.isDirty = true;
        int width = this.flagSurface.getWidth();
        int height = this.flagSurface.getHeight();
        byte[] data = new byte[width * height];
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                data[i * width + j] = this.flagSurface.getPixelValue(j, i);
                this.flagSurface.setPixelValue(j, i, Byte.valueOf((byte)0));
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                int y = height - i - 1;
                int x = j;
                this.flagSurface.setPixelValue(x, y, Byte.valueOf(data[i * width + j]));
            }
        }
    }
}

