/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.util;

import net.minecraft.client.Minecraft;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketCustomPayload;
import toufoumaster.btwaila.BTWaila;

public class VersionHelper {
    public final byte major;
    public final byte minor;
    public final byte patch;

    public VersionHelper(byte major, byte minor, byte patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static VersionHelper getModVersionBasedOnString(String text) {
        try {
            String stringVersion = text.split("\\[\u00a7[a-r0-9]")[1].split("\u00a7[a-r0-9]]")[0];
            String[] versionArray = stringVersion.split("\\.");
            return new VersionHelper(Byte.parseByte(versionArray[0]), Byte.parseByte(versionArray[1]), Byte.parseByte(versionArray[2]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean checkModVersion(VersionHelper versionHelper) {
        boolean isValid = false;
        boolean isUpToDate = false;
        boolean serverOutDated = false;
        if (BTWaila.modVersion.major == versionHelper.major) {
            if (BTWaila.modVersion.minor == versionHelper.minor) {
                if (BTWaila.modVersion.patch >= versionHelper.patch) {
                    isUpToDate = true;
                }
                isValid = true;
            } else if (BTWaila.modVersion.minor >= versionHelper.minor) {
                serverOutDated = true;
            }
        } else if (BTWaila.modVersion.major >= versionHelper.major) {
            serverOutDated = true;
        }
        if (serverOutDated) {
            VersionHelper.serverOutDatedPrint(versionHelper);
        } else if (!isValid) {
            VersionHelper.outDatedPrint(versionHelper);
        } else if (!isUpToDate) {
            VersionHelper.upgradeAvailablePrint(versionHelper);
        }
        return isValid;
    }

    private static void outDatedPrint(VersionHelper versionHelper) {
        String text = "\u00a7eThe current BTWaila version installed \u00a70[\u00a75" + BTWaila.modVersion.major + "." + BTWaila.modVersion.minor + "." + BTWaila.modVersion.patch + "\u00a70]\u00a7e is outdated.";
        String text2 = "Server requirement \u00a70[\u00a75" + versionHelper.major + "." + versionHelper.minor + ".x\u00a70]";
        BTWaila.LOGGER.warn(text + text2);
        Minecraft mc = Minecraft.getMinecraft();
        mc.hudIngame.addChatMessage(text);
        mc.hudIngame.addChatMessage(text2);
    }

    private static void upgradeAvailablePrint(VersionHelper versionHelper) {
        String text = "\u00a74The current BTWaila version installed \u00a70[\u00a75" + BTWaila.modVersion.major + "." + BTWaila.modVersion.minor + "." + BTWaila.modVersion.patch + "\u00a70]\u00a74 got an update. ";
        String text2 = "\u00a74The actual server is using it \u00a70[\u00a75" + versionHelper.major + "." + versionHelper.minor + "." + versionHelper.patch + "\u00a70]\u00a74, don't forget to update";
        BTWaila.LOGGER.info(text + text2);
        Minecraft mc = Minecraft.getMinecraft();
        mc.hudIngame.addChatMessage(text);
        mc.hudIngame.addChatMessage(text2);
    }

    private static void serverOutDatedPrint(VersionHelper versionHelper) {
        String text = "\u00a7eThe current BTWaila version installed on this server is ";
        String text2 = "\u00a7eoutdated \u00a70[\u00a75" + versionHelper.major + "." + versionHelper.minor + "." + versionHelper.patch + "\u00a70]\u00a7e. Please contact the server owner";
        BTWaila.LOGGER.warn(text + text2);
        Minecraft mc = Minecraft.getMinecraft();
        mc.hudIngame.addChatMessage(text);
        mc.hudIngame.addChatMessage(text2);
    }

    public String toString() {
        return "BTWaila VersionHelper: major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + " [" + this.major + "." + this.minor + "." + this.patch + "]";
    }

    public Packet getPacket() {
        return new PacketCustomPayload("BTWaila|VersionCheck", this.compilePayload());
    }

    public byte[] compilePayload() {
        boolean payloadVersion = true;
        return new byte[]{1, this.major, this.minor, this.patch};
    }

    public static void handlePacket(PacketCustomPayload payloadPacket) {
        byte version = payloadPacket.data[0];
        switch (version) {
            case 1: {
                byte major = payloadPacket.data[1];
                byte minor = payloadPacket.data[2];
                byte patch = payloadPacket.data[3];
                VersionHelper serverHelper = new VersionHelper(major, minor, patch);
                if (!VersionHelper.checkModVersion(serverHelper)) break;
                BTWaila.canUseAdvancedTooltips = true;
                break;
            }
            default: {
                BTWaila.LOGGER.warn("Unrecognized version '" + version + "' ignoring!");
            }
        }
    }
}

