/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.gui.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;
import toufoumaster.btwaila.demo.DemoManager;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;

public class DropIconComponent
extends HudComponentMovable {
    public DropIconComponent(String key, Layout layout) {
        super(key, 18, 18, layout);
    }

    public boolean isVisible(Minecraft minecraft) {
        return minecraft.gameSettings.immersiveMode.drawHotbar();
    }

    public void render(Minecraft minecraft, HudIngame HudIngame2, int xScreenSize, int yScreenSize, float partialTick) {
        HitResult hitResult = minecraft.objectMouseOver;
        if (hitResult == null) {
            return;
        }
        if (hitResult.hitType == HitResult.HitType.TILE) {
            Block block = minecraft.currentWorld.getBlock(hitResult.x, hitResult.y, hitResult.z);
            ItemStack[] drops = null;
            if (block != null) {
                drops = block.getBreakResult((World)minecraft.currentWorld, EnumDropCause.PICK_BLOCK, hitResult.x, hitResult.y, hitResult.z, minecraft.currentWorld.getBlockMetadata(hitResult.x, hitResult.y, hitResult.z), null);
                ItemStack icon = block.getDefaultStack();
                if (drops != null && drops.length > 0) {
                    icon = drops[0];
                }
                icon.stackSize = 1;
                this.renderItemDisplayer(minecraft, icon, xScreenSize, yScreenSize);
            }
        } else if (hitResult.hitType == HitResult.HitType.ENTITY) {
            ItemStack itemToRender = this.getEntityIcon(hitResult.entity);
            itemToRender.stackSize = 1;
            this.renderItemDisplayer(minecraft, itemToRender, xScreenSize, yScreenSize);
        }
    }

    public void renderPreview(Minecraft minecraft, Gui gui, Layout layout, int xScreenSize, int yScreenSize) {
        ItemStack icon = null;
        if (DemoManager.getCurrentEntry().block != null) {
            icon = DemoManager.getCurrentEntry().drops[0];
        } else if (DemoManager.getCurrentEntry().entity != null) {
            icon = this.getEntityIcon(DemoManager.getCurrentEntry().entity);
        }
        if (icon != null) {
            this.renderItemDisplayer(minecraft, icon, xScreenSize, yScreenSize);
        }
    }

    protected void renderItemDisplayer(Minecraft minecraft, ItemStack blockResult, int xScreenSize, int yScreenSize) {
        int x = this.getLayout().getComponentX(minecraft, (HudComponent)this, xScreenSize);
        int y = this.getLayout().getComponentY(minecraft, (HudComponent)this, yScreenSize);
        Lighting.enableInventoryLight();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2929);
        Tessellator t = Tessellator.instance;
        ItemModel model = ItemModelDispatcher.getInstance().getDispatch(blockResult);
        model.renderItemIntoGui(t, minecraft.font, minecraft.textureManager, blockResult, x + (this.getXSize(minecraft) - 16) / 2, y + (this.getYSize(minecraft) - 16) / 2, 1.0f, 1.0f);
        model.renderItemOverlayIntoGUI(t, minecraft.font, minecraft.textureManager, blockResult, x + (this.getXSize(minecraft) - 16) / 2, y + (this.getYSize(minecraft) - 16) / 2, 1.0f);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        Lighting.disable();
    }

    public ItemStack getEntityIcon(Entity entity) {
        ItemStack icon = (ItemStack)AdvancedInfoComponent.entityIconMap.get(entity.getClass());
        if (icon == null && entity instanceof Mob) {
            Mob living = (Mob)entity;
            if (!living.mobDrops.isEmpty()) {
                WeightedRandomLootObject lootObject = (WeightedRandomLootObject)living.mobDrops.get(0);
                icon = lootObject.getItemStack();
            }
        }
        if (icon != null) {
            return icon;
        }
        return Items.EGG_CHICKEN.getDefaultStack();
    }
}

