/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.bta.chunk.provider;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import org.slf4j.Logger;

public class ChunkProviderSeedViewer
implements IChunkProvider {
    public static final int CHUNK_RADIUS = 64;
    public static final int CHUNK_MASK = 127;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Chunk blankChunk;
    public ChunkGenerator chunkGenerator;
    private final IChunkLoader chunkLoader;
    private final Chunk[] chunks = new Chunk[16384];
    private final World worldObj;
    int lastQueriedChunkXPos = Integer.MIN_VALUE;
    int lastQueriedChunkZPos = Integer.MIN_VALUE;
    private Chunk lastQueriedChunk;
    private int curChunkX;
    private int curChunkY;

    public ChunkProviderSeedViewer(World world, IChunkLoader ichunkloader, ChunkGenerator chunkGenerator) {
        this.blankChunk = new EmptyChunk(world, 0, 0);
        this.worldObj = world;
        this.chunkLoader = ichunkloader;
        this.chunkGenerator = chunkGenerator;
    }

    @Override
    public void setCurrentChunkOver(int chunkX, int chunkZ) {
        this.curChunkX = chunkX;
        this.curChunkY = chunkZ;
    }

    public boolean canChunkExist(int chunkX, int chunkZ) {
        int byte0 = 63;
        return chunkX >= this.curChunkX - byte0 && chunkZ >= this.curChunkY - byte0 && chunkX <= this.curChunkX + byte0 && chunkZ <= this.curChunkY + byte0;
    }

    @Override
    public void regenerateChunk(int chunkX, int chunkZ) {
        int k = chunkX & 0x7F;
        int l = chunkZ & 0x7F;
        int i1 = k + l * 64 * 2;
        if (this.chunkGenerator == null) {
            return;
        }
        Chunk newChunk = this.chunkGenerator.generate(chunkX, chunkZ);
        newChunk.fixMissingBlocks();
        this.chunks[i1] = newChunk;
        if (!this.chunks[i1].isTerrainPopulated && this.isChunkLoaded(chunkX + 1, chunkZ + 1) && this.isChunkLoaded(chunkX, chunkZ + 1) && this.isChunkLoaded(chunkX + 1, chunkZ)) {
            this.populate(this, chunkX, chunkZ);
        }
        if (this.isChunkLoaded(chunkX - 1, chunkZ) && !this.provideChunk((int)(chunkX - 1), (int)chunkZ).isTerrainPopulated && this.isChunkLoaded(chunkX - 1, chunkZ + 1) && this.isChunkLoaded(chunkX, chunkZ + 1) && this.isChunkLoaded(chunkX - 1, chunkZ)) {
            this.populate(this, chunkX - 1, chunkZ);
        }
        if (this.isChunkLoaded(chunkX, chunkZ - 1) && !this.provideChunk((int)chunkX, (int)(chunkZ - 1)).isTerrainPopulated && this.isChunkLoaded(chunkX + 1, chunkZ - 1) && this.isChunkLoaded(chunkX, chunkZ - 1) && this.isChunkLoaded(chunkX + 1, chunkZ)) {
            this.populate(this, chunkX, chunkZ - 1);
        }
        if (this.isChunkLoaded(chunkX - 1, chunkZ - 1) && !this.provideChunk((int)(chunkX - 1), (int)(chunkZ - 1)).isTerrainPopulated && this.isChunkLoaded(chunkX - 1, chunkZ - 1) && this.isChunkLoaded(chunkX, chunkZ - 1) && this.isChunkLoaded(chunkX - 1, chunkZ)) {
            this.populate(this, chunkX - 1, chunkZ - 1);
        }
    }

    @Override
    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        if (!this.canChunkExist(chunkX, chunkZ)) {
            return false;
        }
        if (chunkX == this.lastQueriedChunkXPos && chunkZ == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return true;
        }
        int k = chunkX & 0x7F;
        int l = chunkZ & 0x7F;
        int chunkIndex = k + l * 64 * 2;
        return this.chunks[chunkIndex] == this.blankChunk || this.chunks[chunkIndex] != null && this.chunks[chunkIndex].isAtLocation(chunkX, chunkZ);
    }

    @Override
    public Chunk prepareChunk(int chunkX, int chunkZ) {
        return this.provideChunk(chunkX, chunkZ);
    }

    @Override
    public Chunk provideChunk(int chunkX, int chunkZ) {
        if (chunkX == this.lastQueriedChunkXPos && chunkZ == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return this.lastQueriedChunk;
        }
        if (!this.worldObj.findingSpawnPoint && !this.canChunkExist(chunkX, chunkZ)) {
            return this.blankChunk;
        }
        int k = chunkX & 0x7F;
        int l = chunkZ & 0x7F;
        int i1 = k + l * 64 * 2;
        if (!this.isChunkLoaded(chunkX, chunkZ)) {
            Chunk chunk;
            if (this.chunks[i1] != null) {
                this.saveChunk(this.chunks[i1]);
                this.chunks[i1].onUnload();
            }
            if ((chunk = this.loadChunk(chunkX, chunkZ)) == null) {
                if (this.chunkGenerator != null) {
                    chunk = this.chunkGenerator.generate(chunkX, chunkZ);
                    chunk.fixMissingBlocks();
                } else {
                    chunk = this.blankChunk;
                }
            }
            this.chunks[i1] = chunk;
            if (this.chunks[i1] != null) {
                this.chunks[i1].onLoad();
            }
            if (!this.chunks[i1].isTerrainPopulated && this.isChunkLoaded(chunkX + 1, chunkZ + 1) && this.isChunkLoaded(chunkX, chunkZ + 1) && this.isChunkLoaded(chunkX + 1, chunkZ)) {
                this.populate(this, chunkX, chunkZ);
            }
            if (this.isChunkLoaded(chunkX - 1, chunkZ) && !this.provideChunk((int)(chunkX - 1), (int)chunkZ).isTerrainPopulated && this.isChunkLoaded(chunkX - 1, chunkZ + 1) && this.isChunkLoaded(chunkX, chunkZ + 1) && this.isChunkLoaded(chunkX - 1, chunkZ)) {
                this.populate(this, chunkX - 1, chunkZ);
            }
            if (this.isChunkLoaded(chunkX, chunkZ - 1) && !this.provideChunk((int)chunkX, (int)(chunkZ - 1)).isTerrainPopulated && this.isChunkLoaded(chunkX + 1, chunkZ - 1) && this.isChunkLoaded(chunkX, chunkZ - 1) && this.isChunkLoaded(chunkX + 1, chunkZ)) {
                this.populate(this, chunkX, chunkZ - 1);
            }
            if (this.isChunkLoaded(chunkX - 1, chunkZ - 1) && !this.provideChunk((int)(chunkX - 1), (int)(chunkZ - 1)).isTerrainPopulated && this.isChunkLoaded(chunkX - 1, chunkZ - 1) && this.isChunkLoaded(chunkX, chunkZ - 1) && this.isChunkLoaded(chunkX - 1, chunkZ)) {
                this.populate(this, chunkX - 1, chunkZ - 1);
            }
            if (this.worldObj.getCurrentWeather() != null) {
                this.worldObj.getCurrentWeather().doChunkLoadEffect(this.worldObj, chunk);
            }
        }
        this.lastQueriedChunkXPos = chunkX;
        this.lastQueriedChunkZPos = chunkZ;
        this.lastQueriedChunk = this.chunks[i1];
        return this.chunks[i1];
    }

    private Chunk loadChunk(int chunkX, int chunkZ) {
        if (this.chunkLoader == null) {
            return this.blankChunk;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.worldObj, chunkX, chunkZ);
            if (chunk != null) {
                chunk.lastSaveTime = this.worldObj.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            LOGGER.error("Error loading chunk at X:{}, Z:{}", chunkX, chunkZ, exception);
            return this.blankChunk;
        }
    }

    private void saveChunk(Chunk chunk) {
    }

    @Override
    public void populate(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, ProgressListener progressUpdate) {
        return false;
    }

    @Override
    public boolean tick() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
        for (Chunk chunk : this.chunks) {
            if (chunk == null) continue;
            chunk.onUnload();
        }
        Arrays.fill(this.chunks, null);
        this.chunkGenerator = null;
        System.gc();
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public String getInfoString() {
        return "ChunkCache: " + this.chunks.length;
    }

    public IChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }
}

