/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.helper;

import com.b100.utils.FileUtils;
import com.b100.utils.interfaces.Condition;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;

public abstract class ReflectionHelper {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static List<Class<?>> getAllClasses(Condition<String> classNameCondition) {
        String[] classPathEntries;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        ArrayList classes = new ArrayList();
        for (String classPathEntry : classPathEntries = System.getProperty("java.class.path").split(";")) {
            File file = new File(classPathEntry);
            if (file.isDirectory()) {
                int l = file.getAbsolutePath().length() + 1;
                List<File> files = FileUtils.getAllFiles(file);
                for (File file2 : files) {
                    if (!file2.getName().endsWith(".class")) continue;
                    ReflectionHelper.tryAddClass(classes, classLoader, file2.getAbsolutePath().substring(l), classNameCondition);
                }
            }
            if (!file.isFile()) continue;
            try {
                ZipFile zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    String entry = ((Object)entries.nextElement()).toString();
                    if (!entry.endsWith(".class")) continue;
                    ReflectionHelper.tryAddClass(classes, classLoader, entry, classNameCondition);
                }
                zip.close();
            }
            catch (IOException e) {
                LOGGER.error("Exception loading class entries from file '{}'!", (Object)file.getPath(), (Object)e);
            }
        }
        return classes;
    }

    private static void tryAddClass(List<Class<?>> classes, ClassLoader classLoader, String fileName, Condition<String> classNameCondition) {
        String className = fileName.substring(0, fileName.length() - 6);
        className = className.replace('\\', '.');
        className = className.replace('/', '.');
        if (classNameCondition == null || classNameCondition.isTrue(className)) {
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(className);
            }
            catch (Throwable e) {
                System.err.println(e.getClass().getName() + ": " + e.getMessage());
            }
            if (clazz != null) {
                classes.add(clazz);
            }
        }
    }
}

