/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.material;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;

public class ArmorMaterial {
    private static final List<ArmorMaterial> ARMOR_MATERIALS = new ArrayList<ArmorMaterial>();
    public final NamespaceID identifier;
    public final int durability;
    private final Map<DamageType, Float> protection = new HashMap<DamageType, Float>();
    public static final ArmorMaterial LEATHER = ArmorMaterial.register(new ArmorMaterial(NamespaceID.getPermanent("minecraft", "cloth"), 180).withProtectionPercentage(DamageType.COMBAT, 20.0f).withProtectionPercentage(DamageType.BLAST, 20.0f).withProtectionPercentage(DamageType.FIRE, 20.0f).withProtectionPercentage(DamageType.FALL, 120.0f));
    public static final ArmorMaterial CHAINMAIL = ArmorMaterial.register(new ArmorMaterial(NamespaceID.getPermanent("minecraft", "chain"), 240).withProtectionPercentage(DamageType.COMBAT, 120.0f).withProtectionPercentage(DamageType.BLAST, 35.0f).withProtectionPercentage(DamageType.FIRE, 35.0f).withProtectionPercentage(DamageType.FALL, 35.0f));
    public static final ArmorMaterial IRON = ArmorMaterial.register(new ArmorMaterial(NamespaceID.getPermanent("minecraft", "iron"), 200).withProtectionPercentage(DamageType.COMBAT, 45.0f).withProtectionPercentage(DamageType.BLAST, 45.0f).withProtectionPercentage(DamageType.FIRE, 45.0f).withProtectionPercentage(DamageType.FALL, 45.0f));
    public static final ArmorMaterial GOLD = ArmorMaterial.register(new ArmorMaterial(NamespaceID.getPermanent("minecraft", "gold"), 120).withProtectionPercentage(DamageType.COMBAT, 70.0f).withProtectionPercentage(DamageType.BLAST, 70.0f).withProtectionPercentage(DamageType.FIRE, 70.0f).withProtectionPercentage(DamageType.FALL, 70.0f));
    public static final ArmorMaterial DIAMOND = ArmorMaterial.register(new ArmorMaterial(NamespaceID.getPermanent("minecraft", "diamond"), 800).withProtectionPercentage(DamageType.COMBAT, 66.0f).withProtectionPercentage(DamageType.BLAST, 66.0f).withProtectionPercentage(DamageType.FIRE, 124.0f).withProtectionPercentage(DamageType.FALL, 66.0f));
    public static final ArmorMaterial STEEL = ArmorMaterial.register(new ArmorMaterial(NamespaceID.getPermanent("minecraft", "steel"), 1200).withProtectionPercentage(DamageType.COMBAT, 55.0f).withProtectionPercentage(DamageType.BLAST, 150.0f).withProtectionPercentage(DamageType.FIRE, 55.0f).withProtectionPercentage(DamageType.FALL, 55.0f));

    public static List<ArmorMaterial> getArmorMaterials() {
        return Collections.unmodifiableList(ARMOR_MATERIALS);
    }

    public static ArmorMaterial register(ArmorMaterial material) {
        ARMOR_MATERIALS.add(material);
        return material;
    }

    public ArmorMaterial(NamespaceID identifier, int durability) {
        this.identifier = identifier.makePermanent();
        this.durability = durability;
        ARMOR_MATERIALS.add(this);
    }

    public float getProtection(DamageType damageType) {
        if (damageType == null) {
            return 0.0f;
        }
        Float protection = this.protection.get(damageType);
        return protection != null ? protection.floatValue() : 0.0f;
    }

    public ArmorMaterial withProtectionPercentage(DamageType damageType, float percent) {
        this.protection.put(damageType, Float.valueOf(percent / 100.0f));
        return this;
    }
}

