/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.item.Item;
import net.minecraft.core.item.material.ArmorMaterial;
import org.jetbrains.annotations.Nullable;

public interface IArmorItem {
    public static final int PIECE_HEAD = 3;
    public static final int PIECE_CHEST = 2;
    public static final int PIECE_LEGS = 1;
    public static final int PIECE_BOOTS = 0;
    public static final int[] ARMOR_PIECE_PROTECTION_VALUES = new int[]{3, 6, 8, 3};
    public static final float[] ARMOR_PIECE_DURABILITY_MODIFIERS = new float[]{0.94f, 0.97f, 1.0f, 0.91f};

    public Item asItem();

    @Nullable
    public ArmorMaterial getArmorMaterial();

    public int getArmorPiece();

    default public int armorPieceProtection() {
        return ARMOR_PIECE_PROTECTION_VALUES[this.getArmorPiece()];
    }

    default public float getArmorPieceProtectionPercentage() {
        return (float)this.armorPieceProtection() / 20.0f;
    }
}

