/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryScrap;
import net.minecraft.core.item.ItemStack;

public class RecipeEntryScrapJsonAdapter
implements RecipeJsonAdapter<RecipeEntryScrap> {
    @Override
    public RecipeEntryScrap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        ItemStack input = (ItemStack)context.deserialize(obj.get("input").getAsJsonObject(), (Type)((Object)ItemStack.class));
        ItemStack scrapItem = (ItemStack)context.deserialize(obj.get("output").getAsJsonObject(), (Type)((Object)ItemStack.class));
        int maxYield = obj.get("maxYield").getAsInt();
        return new RecipeEntryScrap(input.getItem(), scrapItem.getItem(), maxYield);
    }

    @Override
    public JsonElement serialize(RecipeEntryScrap src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("name", src.toString());
        object.addProperty("type", Registries.RECIPE_TYPES.getKey(src.getClass()));
        object.add("input", context.serialize(new ItemStack(src.itemToScrap)));
        object.add("output", context.serialize(new ItemStack(src.scrapYield)));
        object.addProperty("maxYield", src.maxYield);
        return object;
    }
}

