/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe;

import java.util.Objects;
import net.minecraft.core.util.collection.Pair;

public class SearchQuery {
    public String rawQuery;
    public SearchMode mode;
    public Pair<SearchScope, String> scope;
    public Pair<QueryType, String> query;
    public boolean strict;

    public SearchQuery(String rawQuery, SearchMode mode, Pair<SearchScope, String> scope, Pair<QueryType, String> query, boolean strict) {
        this.rawQuery = rawQuery;
        this.mode = mode;
        this.scope = scope;
        this.query = query;
        this.strict = strict;
    }

    public static SearchQuery resolve(String rawQuery) {
        Pair<SearchScope, String> scope;
        String scopePart;
        SearchMode mode = rawQuery.startsWith("r:") || rawQuery.startsWith("R:") ? SearchMode.RECIPE : (rawQuery.startsWith("u:") || rawQuery.startsWith("U:") ? SearchMode.USAGE : SearchMode.ALL);
        String modeRemoved = rawQuery.replace("r:", "").replace("u:", "").replace("R:", "").replace("U:", "");
        if (modeRemoved.startsWith("@") && modeRemoved.split(" ").length > 1) {
            scopePart = modeRemoved.split(" ")[0];
            String searchPart = modeRemoved.split(" ")[1];
            scope = scopePart.contains(":") ? Pair.of(SearchScope.NAMESPACE_GROUP, scopePart.replace("@", "")) : Pair.of(SearchScope.NAMESPACE, scopePart.replace("@", ""));
        } else {
            scope = modeRemoved.startsWith("@") ? ((scopePart = modeRemoved.trim()).contains(":") ? Pair.of(SearchScope.NAMESPACE_GROUP, scopePart.replace("@", "")) : Pair.of(SearchScope.NAMESPACE, scopePart.replace("@", ""))) : Pair.of(SearchScope.NONE, "");
        }
        String scopeRemoved = modeRemoved.replace("@" + scope.getRight(), "").trim();
        boolean strict = rawQuery.endsWith("!");
        scopeRemoved = scopeRemoved.replace("!", "");
        Pair<QueryType, String> query = scopeRemoved.startsWith("#") ? Pair.of(QueryType.GROUP, scopeRemoved.replace("#", "")) : Pair.of(QueryType.NAME, scopeRemoved);
        return new SearchQuery(rawQuery, mode, scope, query, strict);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchQuery that = (SearchQuery)o;
        if (this.strict != that.strict) {
            return false;
        }
        if (!Objects.equals(this.rawQuery, that.rawQuery)) {
            return false;
        }
        if (this.mode != that.mode) {
            return false;
        }
        if (!Objects.equals(this.scope, that.scope)) {
            return false;
        }
        return Objects.equals(this.query, that.query);
    }

    public String toString() {
        return "SearchQuery{rawQuery='" + this.rawQuery + '\'' + ", mode=" + (Object)((Object)this.mode) + ", scope=" + this.scope + ", query=" + this.query + ", strict=" + this.strict + '}';
    }

    public static enum SearchMode {
        ALL,
        RECIPE,
        USAGE;

    }

    public static enum SearchScope {
        NONE,
        NAMESPACE,
        NAMESPACE_GROUP;

    }

    public static enum QueryType {
        NAME,
        GROUP;

    }
}

