/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.worldtype;

import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.client.render.worldtype.WorldTypeFXEmpty;
import net.minecraft.client.render.worldtype.WorldTypeFXNether;
import net.minecraft.client.render.worldtype.WorldTypeFXOverworld;
import net.minecraft.client.render.worldtype.WorldTypeFXParadise;
import net.minecraft.client.util.dispatch.Dispatcher;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;

public class WorldTypeFXDispatcher
extends Dispatcher<WorldType, WorldTypeFX> {
    private static WorldTypeFXDispatcher instance = new WorldTypeFXDispatcher();

    public static WorldTypeFXDispatcher getInstance() {
        return instance;
    }

    private WorldTypeFXDispatcher() {
        instance = this;
        this.addDispatch(new WorldTypeFX(WorldTypes.DEBUG).setCloudHeight(108.0f).setHasGround(false));
        this.addDispatch(new WorldTypeFXEmpty(WorldTypes.EMPTY).setCloudHeight(108.0f).setHasGround(false));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_EXTENDED).setHasAurora(true));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_DEFAULT).setHasAurora(true));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_FLOATING).setHasAurora(true).setCloudHeight(32.0f));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_AMPLIFIED).setHasAurora(true).setCloudHeight(108.0f));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_RETRO).setHasAurora(true));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_ISLANDS).setHasAurora(true));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_WINTER).setHasAurora(true));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_WOODS).setHasAurora(true));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_PARADISE).setHasAurora(true));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_INLAND).setHasAurora(true));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_CLASSIC).setHasAurora(true));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_INDEV).setHasAurora(true));
        this.addDispatch(new WorldTypeFXOverworld(WorldTypes.OVERWORLD_SKYBLOCK).setHasAurora(true));
        this.addDispatch(new WorldTypeFX(WorldTypes.OVERWORLD_HELL));
        this.addDispatch(new WorldTypeFX(WorldTypes.FLAT).setCloudHeight(236.0f));
        this.addDispatch(new WorldTypeFXNether(WorldTypes.NETHER_DEFAULT).setHasClouds(false).setHasSky(false));
        this.addDispatch(new WorldTypeFXNether(WorldTypes.NETHER_SKYBLOCK).setHasClouds(false).setHasSky(false));
        this.addDispatch(new WorldTypeFXParadise(WorldTypes.PARADISE_DEFAULT).setCloudHeight(8.0f).setHasGround(false));
    }

    public void addDispatch(WorldTypeFX worldTypeFX) {
        this.addDispatch(worldTypeFX.worldType, worldTypeFX);
    }

    @Override
    public void addDispatch(WorldType key, WorldTypeFX value) {
        assert (!this.dispatches.containsKey(key)) : "WorldType " + key.getLanguageKey() + " is already assigned a WorldTypeFX! " + value.getClass();
        super.addDispatch(key, value);
    }

    @Override
    protected WorldTypeFX getDefault() {
        return (WorldTypeFX)this.dispatches.get(WorldTypes.EMPTY);
    }
}

