/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;

public class ModelBiped
extends ModelBase {
    public Cube head;
    public Cube hair;
    public Cube body;
    public Cube armRight;
    public Cube armLeft;
    public Cube legRight;
    public Cube legLeft;
    public Cube ear;
    public Cube cloak = new Cube(0, 0);
    public boolean holdingLeftHand = false;
    public boolean holdingRightHand = false;
    public boolean holdingLarge = false;
    public boolean sneaking = false;

    public ModelBiped() {
        this(0.0f);
    }

    public ModelBiped(float expansion) {
        this(expansion, 0.0f);
    }

    public ModelBiped(float expansion, float yRotOffset) {
        this.cloak.addBox(-5.0f, 0.0f, -1.0f, 10, 16, 1, expansion);
        this.ear = new Cube(24, 0);
        this.ear.addBox(-3.0f, -6.0f, -1.0f, 6, 6, 1, expansion);
        this.head = new Cube(0, 0);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, expansion);
        this.head.setRotationPoint(0.0f, 0.0f + yRotOffset, 0.0f);
        this.hair = new Cube(32, 0);
        this.hair.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, expansion + 0.5f);
        this.hair.setRotationPoint(0.0f, 0.0f + yRotOffset, 0.0f);
        this.body = new Cube(16, 16);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4, expansion);
        this.body.setRotationPoint(0.0f, 0.0f + yRotOffset, 0.0f);
        this.armRight = new Cube(40, 16);
        this.armRight.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, expansion);
        this.armRight.setRotationPoint(-5.0f, 2.0f + yRotOffset, 0.0f);
        this.armLeft = new Cube(40, 16);
        this.armLeft.mirror = true;
        this.armLeft.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, expansion);
        this.armLeft.setRotationPoint(5.0f, 2.0f + yRotOffset, 0.0f);
        this.legRight = new Cube(0, 16);
        this.legRight.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, expansion);
        this.legRight.setRotationPoint(-2.0f, 12.0f + yRotOffset, 0.0f);
        this.legLeft = new Cube(0, 16);
        this.legLeft.mirror = true;
        this.legLeft.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, expansion);
        this.legLeft.setRotationPoint(2.0f, 12.0f + yRotOffset, 0.0f);
    }

    @Override
    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.head.render(scale);
        this.body.render(scale);
        this.armRight.render(scale);
        this.armLeft.render(scale);
        this.legRight.render(scale);
        this.legLeft.render(scale);
        this.hair.render(scale);
    }

    @Override
    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.head.yRot = headYaw / 57.29578f;
        this.head.xRot = headPitch / 57.29578f;
        this.hair.yRot = this.head.yRot;
        this.hair.xRot = this.head.xRot;
        if (this.holdingLarge) {
            this.armRight.xRot = MathHelper.cos(limbSwing / 2.0f * 0.6662f) * 2.0f * limbYaw * 0.125f - 0.65f;
            this.armLeft.xRot = MathHelper.cos(limbSwing / 2.0f * 0.6662f) * 2.0f * limbYaw * 0.125f - 0.65f;
        } else {
            this.armRight.xRot = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 2.0f * limbYaw * 0.5f;
            this.armLeft.xRot = MathHelper.cos(limbSwing * 0.6662f) * 2.0f * limbYaw * 0.5f;
        }
        this.armRight.zRot = 0.0f;
        this.armLeft.zRot = 0.0f;
        this.legRight.xRot = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        this.legLeft.xRot = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
        this.legRight.yRot = 0.0f;
        this.legLeft.yRot = 0.0f;
        if (this.isRiding) {
            this.armRight.xRot += -0.6283185f;
            this.armLeft.xRot += -0.6283185f;
            this.legRight.xRot = -1.256637f;
            this.legLeft.xRot = -1.256637f;
            this.legRight.yRot = 0.3141593f;
            this.legLeft.yRot = -0.3141593f;
        }
        if (this.holdingLeftHand) {
            this.armLeft.xRot = this.armLeft.xRot * 0.5f - 0.3141593f;
        }
        if (this.holdingRightHand) {
            this.armRight.xRot = this.armRight.xRot * 0.5f - 0.3141593f;
        }
        this.armRight.yRot = 0.0f;
        this.armLeft.yRot = 0.0f;
        if (this.onGround > -9990.0f) {
            float f6 = this.onGround;
            this.body.yRot = MathHelper.sin(MathHelper.sqrt_float(f6) * (float)Math.PI * 2.0f) * 0.2f;
            this.armRight.z = MathHelper.sin(this.body.yRot) * 5.0f;
            this.armRight.x = -MathHelper.cos(this.body.yRot) * 5.0f;
            this.armLeft.z = -MathHelper.sin(this.body.yRot) * 5.0f;
            this.armLeft.x = MathHelper.cos(this.body.yRot) * 5.0f;
            this.armRight.yRot += this.body.yRot;
            this.armLeft.yRot += this.body.yRot;
            this.armLeft.xRot += this.body.xRot;
            f6 = 1.0f - this.onGround;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            float f7 = MathHelper.sin(f6 * (float)Math.PI);
            float f8 = MathHelper.sin(this.onGround * (float)Math.PI) * -(this.head.xRot - 0.7f) * 0.75f;
            this.armRight.xRot = (float)((double)this.armRight.xRot - ((double)f7 * 1.2 + (double)f8));
            this.armRight.yRot += this.body.yRot * 2.0f;
            this.armRight.zRot = MathHelper.sin(this.onGround * (float)Math.PI) * -0.4f;
        }
        if (this.sneaking) {
            this.body.xRot = 0.5f;
            this.legRight.xRot -= 0.0f;
            this.legLeft.xRot -= 0.0f;
            this.armRight.xRot += 0.4f;
            if (this.holdingLarge) {
                this.armRight.xRot -= 0.4f;
                this.armLeft.xRot -= 0.5f;
            }
            this.legRight.z = 4.0f;
            this.legLeft.z = 4.0f;
            this.legRight.y = 9.0f;
            this.legLeft.y = 9.0f;
            this.head.y = 1.0f;
            this.hair.y = 1.0f;
        } else {
            this.body.xRot = 0.0f;
            this.legRight.z = 0.0f;
            this.legLeft.z = 0.0f;
            this.legRight.y = 12.0f;
            this.legLeft.y = 12.0f;
            this.head.y = 0.0f;
            this.hair.y = 0.0f;
        }
        this.armRight.zRot += MathHelper.cos(limbPitch * 0.09f) * 0.05f + 0.05f;
        this.armLeft.zRot -= MathHelper.cos(limbPitch * 0.09f) * 0.05f + 0.05f;
        this.armRight.xRot += MathHelper.sin(limbPitch * 0.067f) * 0.05f;
        this.armLeft.xRot -= MathHelper.sin(limbPitch * 0.067f) * 0.05f;
    }

    public void renderCloak(float scale) {
        this.cloak.render(scale);
    }
}

