/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.animal.MobSquid;
import org.lwjgl.opengl.GL11;

public class MobRendererSquid
extends MobRenderer<MobSquid> {
    public MobRendererSquid(ModelBase modelbase, float f) {
        super(modelbase, f);
    }

    @Override
    protected float limbSway(MobSquid squid, float partialTick) {
        return squid.oldTentacleAngle + (squid.tentacleAngle - squid.oldTentacleAngle) * partialTick;
    }

    @Override
    protected void setupRotations(MobSquid squid, float ticksExisted, float bodyYaw, float partialTick) {
        if (squid.isSpecial()) {
            super.setupRotations(squid, ticksExisted, bodyYaw, partialTick);
        } else {
            float pitch = squid.xBodyRotO + (squid.xBodyRot - squid.xBodyRotO) * partialTick;
            float yaw = squid.zBodyRotO + (squid.zBodyRot - squid.zBodyRotO) * partialTick;
            GL11.glTranslatef(0.0f, 0.5f, 0.0f);
            GL11.glRotatef(180.0f - bodyYaw, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(pitch, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(yaw, 0.0f, 1.0f, 0.0f);
            GL11.glTranslatef(0.0f, -1.2f, 0.0f);
        }
    }

    @Override
    public void renderPreview(Tessellator tessellator, MobSquid squid, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef(0.0f, 1.25f, 0.0f);
        super.renderPreview(tessellator, squid, x, y, z, yaw, partialTick);
        GL11.glPopMatrix();
    }
}

