/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelChest;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelChestPainted<T extends BlockLogic>
extends BlockModelChest<T> {
    public static final IconCoordinate[][] texCoords = new IconCoordinate[16][];
    public static final int TEX_SINGLE_FRONT = 0;
    public static final int TEX_LEFT_FRONT = 1;
    public static final int TEX_RIGHT_FRONT = 2;
    public static final int TEX_LEFT_BACK = 3;
    public static final int TEX_RIGHT_BACK = 4;
    public static final int TEX_SIDE = 5;
    public static final int TEX_TOP = 6;
    public static final int TEX_LEFT_TOP = 7;
    public static final int TEX_RIGHT_TOP = 8;

    public BlockModelChestPainted(Block<T> block) {
        super(block, "minecraft:block/chest/planks/");
    }

    @Override
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int meta = blockAccess.getBlockMetadata(x, y, z);
        int color = meta >> 4;
        Side facing = BlockLogicChest.getDirectionFromMeta(meta).getSide();
        BlockLogicChest.Type type = BlockLogicChest.getTypeFromMeta(meta);
        if (side == Side.TOP || side == Side.BOTTOM) {
            if (type == BlockLogicChest.Type.LEFT) {
                return texCoords[color][7];
            }
            if (type == BlockLogicChest.Type.RIGHT) {
                return texCoords[color][8];
            }
            return texCoords[color][6];
        }
        if (type == BlockLogicChest.Type.SINGLE && side == facing) {
            return texCoords[color][0];
        }
        if (type == BlockLogicChest.Type.LEFT) {
            if (side == facing) {
                return texCoords[color][1];
            }
            if (side == facing.getOpposite()) {
                return texCoords[color][4];
            }
        }
        if (type == BlockLogicChest.Type.RIGHT) {
            if (side == facing) {
                return texCoords[color][2];
            }
            if (side == facing.getOpposite()) {
                return texCoords[color][3];
            }
        }
        if (side.getAxis() != Axis.Y) {
            return texCoords[color][5];
        }
        return texCoords[color][6];
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int color = data >> 4;
        if (side == Side.SOUTH) {
            return texCoords[color][0];
        }
        if (side.isHorizontal()) {
            return texCoords[color][5];
        }
        return texCoords[color][6];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            String rootKey = "minecraft:block/chest/planks_" + c.colorID + "/";
            BlockModelChestPainted.texCoords[c.blockMeta] = new IconCoordinate[9];
            BlockModelChestPainted.texCoords[c.blockMeta][0] = TextureRegistry.getTexture(rootKey + "front");
            BlockModelChestPainted.texCoords[c.blockMeta][1] = TextureRegistry.getTexture(rootKey + "left_front");
            BlockModelChestPainted.texCoords[c.blockMeta][2] = TextureRegistry.getTexture(rootKey + "right_front");
            BlockModelChestPainted.texCoords[c.blockMeta][3] = TextureRegistry.getTexture(rootKey + "left_back");
            BlockModelChestPainted.texCoords[c.blockMeta][4] = TextureRegistry.getTexture(rootKey + "right_back");
            BlockModelChestPainted.texCoords[c.blockMeta][5] = TextureRegistry.getTexture(rootKey + "side");
            BlockModelChestPainted.texCoords[c.blockMeta][6] = TextureRegistry.getTexture(rootKey + "top");
            BlockModelChestPainted.texCoords[c.blockMeta][7] = TextureRegistry.getTexture(rootKey + "top_left");
            BlockModelChestPainted.texCoords[c.blockMeta][8] = TextureRegistry.getTexture(rootKey + "top_right");
        }
    }
}

