/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicAxisAligned;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;

public class BlockModelAxisAligned<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelAxisAligned(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        int meta = BlockModelAxisAligned.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        Axis axis = BlockLogicAxisAligned.metaToAxis(meta);
        switch (axis) {
            case Y: {
                BlockModelAxisAligned.renderBlocks.uvRotateEast = 0;
                BlockModelAxisAligned.renderBlocks.uvRotateWest = 0;
                BlockModelAxisAligned.renderBlocks.uvRotateSouth = 0;
                BlockModelAxisAligned.renderBlocks.uvRotateNorth = 0;
                break;
            }
            case Z: {
                BlockModelAxisAligned.renderBlocks.uvRotateSouth = 1;
                BlockModelAxisAligned.renderBlocks.uvRotateNorth = 1;
                break;
            }
            case X: {
                BlockModelAxisAligned.renderBlocks.uvRotateEast = 1;
                BlockModelAxisAligned.renderBlocks.uvRotateWest = 1;
                BlockModelAxisAligned.renderBlocks.uvRotateTop = 1;
                BlockModelAxisAligned.renderBlocks.uvRotateBottom = 1;
            }
        }
        this.renderStandardBlock(tessellator, this.block.getBlockBoundsFromState(BlockModelAxisAligned.renderBlocks.blockAccess, x, y, z), x, y, z);
        this.resetRenderBlocks();
        return true;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (6 * (data & 3) + side.getId() >= Sides.orientationLookUpXYZAligned.length) {
            return TextureRegistry.getTexture("minecraft:block/grass_top");
        }
        return super.getBlockTextureFromSideAndMetadata(Side.getSideById(Sides.orientationLookUpXYZAligned[6 * (data & 3) + side.getId()]), data);
    }
}

