/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.brigadier.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.Collection;

public class ArgumentTypeInteger
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0", "123", "-123");
    private final int minimum;
    private final int maximum;

    private ArgumentTypeInteger(int minimum, int maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public static ArgumentTypeInteger integer() {
        return ArgumentTypeInteger.integer(Integer.MIN_VALUE);
    }

    public static ArgumentTypeInteger integer(int min) {
        return ArgumentTypeInteger.integer(min, Integer.MAX_VALUE);
    }

    public static ArgumentTypeInteger integer(int min, int max) {
        return new ArgumentTypeInteger(min, max);
    }

    public static int getInteger(CommandContext<?> context, String name) {
        return context.getArgument(name, Integer.TYPE);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public Integer parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        int result = reader.readInt();
        if (result < this.minimum) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooLow().createWithContext(reader, result, this.minimum);
        }
        if (result > this.maximum) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().createWithContext(reader, result, this.maximum);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArgumentTypeInteger)) {
            return false;
        }
        ArgumentTypeInteger that = (ArgumentTypeInteger)o;
        return this.maximum == that.maximum && this.minimum == that.minimum;
    }

    public int hashCode() {
        return 31 * this.minimum + this.maximum;
    }

    public String toString() {
        if (this.minimum == Integer.MIN_VALUE && this.maximum == Integer.MAX_VALUE) {
            return "integer()";
        }
        if (this.maximum == Integer.MAX_VALUE) {
            return "integer(" + this.minimum + ")";
        }
        return "integer(" + this.minimum + ", " + this.maximum + ")";
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

