/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.ui;

import dev.schmarrn.lighty.SMACH;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.core.lang.I18n;

public class ModeSwitcherScreen
extends Screen {
    private static final List<Mode> MODES = new ArrayList<Mode>();
    private static final int START_HEIGHT = 15;
    private static final int DELTA_HEIGHT = 24;
    private TooltipElement tooltipElement;

    public void init() {
        this.tooltipElement = new TooltipElement(this.mc);
        int height = 39;
        I18n i18n = I18n.getInstance();
        this.buttons.clear();
        this.buttons.add(new ButtonElement(0, this.width / 2 - 75, height, 150, 20, this.getStatus()));
        height += 6;
        int index = 0;
        for (Mode mode : MODES) {
            this.buttons.add(new ButtonElement(index + 2, this.width / 2 - 75, height += 24, 150, 20, i18n.translateKey(mode.title)));
            ++index;
        }
        this.buttons.add(new ButtonElement(1, this.width / 2 - 75, (height += 24) + 6, 150, 20, i18n.translateKey("gui.lighty.modeSwitcher.done")));
    }

    private String getStatus() {
        I18n i18n = I18n.getInstance();
        return i18n.translateKeyAndFormat("gui.lighty.modeSwitcher.toggle", new Object[]{SMACH.isEnabled() ? i18n.translateKey("gui.lighty.modeSwitcher.on") : i18n.translateKey("gui.lighty.modeSwitcher.off")});
    }

    public void render(int mx, int my, float partialTick) {
        I18n i18n = I18n.getInstance();
        this.renderBackground();
        this.drawStringCentered(Minecraft.getMinecraft().font, i18n.translateKey("gui.lighty.modeSwitcher.title"), this.width / 2, 15, 0xFFFFFF);
        super.render(mx, my, partialTick);
        for (ButtonElement button : this.buttons) {
            if (!button.isHovered(mx, my) || button.id <= 1) continue;
            Mode mode = MODES.get(button.id - 2);
            this.tooltipElement.render(i18n.translateKey(mode.tooltip), mx, my, 8, -8);
        }
    }

    protected void buttonClicked(ButtonElement button) {
        if (button.enabled) {
            if (button.id == 0) {
                SMACH.toggle();
                ((ButtonElement)this.buttons.get((int)0)).displayString = this.getStatus();
            } else if (button.id == 1) {
                Minecraft minecraft = Minecraft.getMinecraft();
                minecraft.displayScreen(null);
            } else {
                Mode mode = MODES.get(button.id - 2);
                mode.onPress.run();
                ((ButtonElement)this.buttons.get((int)0)).displayString = this.getStatus();
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static void addButton(String title, String tooltip, Runnable onPress) {
        MODES.add(new Mode(title, tooltip, onPress));
    }

    public static class Mode {
        public String title;
        public String tooltip;
        public Runnable onPress;

        public Mode(String title, String tooltip, Runnable onPress) {
            this.title = title;
            this.tooltip = tooltip;
            this.onPress = onPress;
        }
    }
}

