/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.ui;

import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.event.Compute;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.gui.options.components.OptionsCategory;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.gui.options.components.ShortcutComponent;
import net.minecraft.client.gui.options.data.OptionsPage;
import net.minecraft.client.util.helper.FileOpener;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.ItemStack;

public class LightyConfigScreen
extends ScreenOptions {
    private static final List<OptionsPage> OPTION_PAGES = new ArrayList<OptionsPage>();
    private static final List<Supplier<OptionsComponent>> MODE_OPTIONS = new ArrayList<Supplier<OptionsComponent>>();

    public LightyConfigScreen(Screen parent) {
        super(parent, LightyConfigScreen.getDefaultPage());
    }

    public void removed() {
        for (OptionsPage optionPage : OPTION_PAGES) {
            for (OptionsComponent component : optionPage.getComponents()) {
                component.onClose();
            }
        }
        super.removed();
        Config.save();
        Compute.markDirty();
    }

    public void mouseReleased(int mx, int my, int buttonNum) {
        super.mouseReleased(mx, my, buttonNum);
        Compute.markDirty();
    }

    public static OptionsPage getDefaultPage() {
        return OPTION_PAGES.get(0);
    }

    public static List<OptionsPage> getPages() {
        return OPTION_PAGES;
    }

    public static void register() {
        OPTION_PAGES.add(new OptionsPage("gui.lighty.options.general.title", new ItemStack(Blocks.TORCH_COAL)).withComponent((OptionsComponent)new OptionsCategory("gui.lighty.options.toggle").withComponent((OptionsComponent)Config.SHOW_SAFE.getOptionInstance()).withComponent((OptionsComponent)Config.SHOULD_AUTO_ON.getOptionInstance())).withComponent((OptionsComponent)new OptionsCategory("gui.lighty.options.visual").withComponent((OptionsComponent)Config.OVERLAY_DISTANCE.getOptionInstance()).withComponent((OptionsComponent)Config.OVERLAY_BRIGHTNESS.getOptionInstance()).withComponent((OptionsComponent)Config.OVERLAY_TRANSPARENCY.getOptionInstance())).withComponent((OptionsComponent)new OptionsCategory("gui.lighty.options.advanced").withComponent((OptionsComponent)Config.SKY_THRESHOLD.getOptionInstance()).withComponent((OptionsComponent)Config.BLOCK_THRESHOLD.getOptionInstance()).withComponent((OptionsComponent)new ShortcutComponent("gui.lighty.options.page.advanced.button.open_folder", () -> FileOpener.open((File)new File(FabricLoader.getInstance().getConfigDir().toString(), "lighty"))))));
        OptionsPage page = new OptionsPage("gui.lighty.options.modes.title", new ItemStack(Blocks.BOOKSHELF_PLANKS_OAK));
        for (Supplier<OptionsComponent> component : MODE_OPTIONS) {
            page.withComponent(component.get());
        }
        MODE_OPTIONS.clear();
        OPTION_PAGES.add(page);
    }

    @SafeVarargs
    public static void addModeOption(Supplier<OptionsComponent> ... components) {
        Collections.addAll(MODE_OPTIONS, components);
    }
}

