/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.mode;

import dev.schmarrn.lighty.config.Config;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.world.chunk.Chunk;

public class Provider {
    public static boolean isBlocked(int x, int y, int z, WorldClient world) {
        Block block = world.getBlock(x, y, z);
        if (y < 0 || y > world.getHeightBlocks() - 1) {
            return true;
        }
        return block != null && (block.hasTag(BlockTags.PREVENT_MOB_SPAWNS) || block.getMaterial().isSolid()) || !world.isBlockNormalCube(x, y - 1, z) || world.isBlockNormalCube(x, y, z) || world.getBlockMaterial(x, y, z).isLiquid();
    }

    @Nullable
    public static Pair<Integer, Integer> compute(WorldClient world, int x, int y, int z) {
        Minecraft minecraft = Minecraft.getMinecraft();
        WorldClient currentWorld = minecraft.currentWorld;
        if (currentWorld == null) {
            return null;
        }
        Chunk chunk = world.getChunkFromBlockCoords(x, z);
        int blockLightLevel = chunk.getBrightness(LightLayer.Block, x & 0xF, y + 1, z & 0xF);
        int skyLightLevel = chunk.getBrightness(LightLayer.Sky, x & 0xF, y + 1, z & 0xF);
        return Pair.of((Object)blockLightLevel, (Object)skyLightLevel);
    }

    @Nullable
    public static Integer getColor(Pair<Integer, Integer> light) {
        return Provider.getColor((Integer)light.getLeft(), (Integer)light.getRight());
    }

    @Nullable
    public static Integer getColor(int blockLightLevel, int skyLightLevel) {
        int color = (Integer)Config.OVERLAY_GREEN.getValue();
        if (blockLightLevel <= (Integer)Config.BLOCK_THRESHOLD.getValue()) {
            color = skyLightLevel <= (Integer)Config.SKY_THRESHOLD.getValue() ? ((Integer)Config.OVERLAY_RED.getValue()).intValue() : ((Integer)Config.OVERLAY_ORANGE.getValue()).intValue();
        } else if (!((Boolean)Config.SHOW_SAFE.getValue()).booleanValue()) {
            return null;
        }
        return color;
    }

    static class Pos {
        public int x;
        public int y;
        public int z;

        public Pos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

