/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.mode;

import dev.schmarrn.lighty.api.LightyMode;
import dev.schmarrn.lighty.api.ModeManager;
import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.mode.Provider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.options.components.OptionsCategory;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;

public class NumberMode
extends LightyMode<Provider.Pos, Data> {
    private static final float TEXTURE_SIZE = 32.0f;

    public static void init() {
        ModeManager.registerMode("lighty.number_mode", new NumberMode());
        ModeManager.addOptions(() -> new OptionsCategory("gui.modeSwitcher.lighty.number_mode").withComponent((OptionsComponent)Config.SHOW_SKYLIGHT_LEVEL.getOptionInstance()).withComponent((OptionsComponent)Config.SHOW_ABOVE_HITBOX.getOptionInstance()));
    }

    @Override
    public void compute(WorldClient world, int x, int y, int z) {
        if (Provider.isBlocked(x, y + 1, z, world)) {
            return;
        }
        Pair<Integer, Integer> light = Provider.compute(world, x, y, z);
        if (light == null) {
            return;
        }
        Integer color = Provider.getColor(light);
        if (color == null) {
            return;
        }
        double offset = 0.0;
        Block block = world.getBlock(x, y + 1, z);
        if (block != null) {
            AABB bounds = block.getBlockBoundsFromState((WorldSource)world, x, y + 1, z);
            offset += bounds.maxY;
        }
        this.cache.put(new Provider.Pos(x, y + 1, z), new Data((Integer)light.getLeft(), (Integer)light.getRight(), offset, color));
    }

    @Override
    public void render(float partialTicks) {
        Minecraft minecraft = Minecraft.getMinecraft();
        ICamera camera = minecraft.activeCamera;
        if (camera == null) {
            return;
        }
        GL11.glPushMatrix();
        if ((Integer)Config.OVERLAY_TRANSPARENCY.getValue() < 100) {
            GL11.glEnable((int)3042);
        }
        if (LightmapHelper.isLightmapEnabled()) {
            Integer light = (Integer)Config.OVERLAY_BRIGHTNESS.getValue();
            LightmapHelper.setLightmapCoord((int)light, (int)light);
        }
        this.cache.forEach((pos, data) -> {
            double x = (double)pos.x + 0.5 - camera.getX(partialTicks);
            double y = (double)pos.y + 0.05 - camera.getY(partialTicks);
            double z = (double)pos.z + 0.5 - camera.getZ(partialTicks);
            if (((Boolean)Config.SHOW_ABOVE_HITBOX.getValue()).booleanValue()) {
                y += data.offset;
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glScalef((float)0.03125f, (float)-0.03125f, (float)0.03125f);
            GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)(camera.getYRot() - 180.0), (double)0.0, (double)0.0, (double)1.0);
            float offset = (Boolean)Config.SHOW_SKYLIGHT_LEVEL.getValue() != false ? 4.5f : 0.0f;
            NumberMode.renderNumber(data.blockLightLevel, data.color, -offset);
            if (((Boolean)Config.SHOW_SKYLIGHT_LEVEL.getValue()).booleanValue()) {
                NumberMode.renderNumber(data.skyLightLevel, data.color, offset);
            }
            GL11.glPopMatrix();
        });
        if ((Integer)Config.OVERLAY_TRANSPARENCY.getValue() < 100) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    private static void renderNumber(int light, int color, float y_offset) {
        NumberMode.renderNumber(light, color, y_offset, 0.0f);
    }

    private static void renderNumber(int light, int color, float y_offset, float x_offset) {
        if (light > 15) {
            light = 15;
        }
        if (light >= 10) {
            int secondDigit = light % 10;
            light /= 10;
            NumberMode.renderNumber(secondDigit, color, y_offset, (x_offset -= 4.0f) + 8.0f);
        }
        int x = light % 4 * 8;
        int y = light / 4 * 8;
        Minecraft.getMinecraft().textureManager.loadTexture("/assets/lighty/textures/block/numbers.png").bind();
        NumberMode.drawTexture(-2.5f + x_offset, -3.0f + y_offset, 0.0f, x, y, 8.0f, 8.0f, color);
    }

    private static void drawTexture(float x, float y, float z, float u, float v, float width, float height, int color) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, (int)(2.55 * (double)((Integer)Config.OVERLAY_TRANSPARENCY.getValue()).intValue()));
        tessellator.addVertexWithUV((double)x, (double)(y + height), (double)z, (double)(u / 32.0f), (double)((v + height) / 32.0f));
        tessellator.addVertexWithUV((double)(x + width), (double)(y + height), (double)z, (double)((u + width) / 32.0f), (double)((v + height) / 32.0f));
        tessellator.addVertexWithUV((double)(x + width), (double)y, (double)z, (double)((u + width) / 32.0f), (double)(v / 32.0f));
        tessellator.addVertexWithUV((double)x, (double)y, (double)z, (double)(u / 32.0f), (double)(v / 32.0f));
        tessellator.draw();
    }

    static class Data {
        public int blockLightLevel;
        public int skyLightLevel;
        public double offset;
        public int color;

        public Data(int blockLightLevel, int skyLightLevel, double offset, int color) {
            this.blockLightLevel = blockLightLevel;
            this.skyLightLevel = skyLightLevel;
            this.offset = offset;
            this.color = color;
        }
    }
}

