/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.mode;

import dev.schmarrn.lighty.api.LightyMode;
import dev.schmarrn.lighty.api.ModeManager;
import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.mode.Provider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.options.components.OptionsCategory;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;

public class CrossMode
extends LightyMode<Provider.Pos, Pair<Double, Integer>> {
    public static void init() {
        ModeManager.registerMode("lighty.cross_mode", new CrossMode());
        ModeManager.addOptions(() -> new OptionsCategory("gui.modeSwitcher.lighty.cross_mode").withComponent((OptionsComponent)Config.OVERLAY_LINE_THICKNESS.getOptionInstance()));
    }

    @Override
    public void compute(WorldClient world, int x, int y, int z) {
        if (Provider.isBlocked(x, y + 1, z, world)) {
            return;
        }
        Pair<Integer, Integer> light = Provider.compute(world, x, y, z);
        if (light == null) {
            return;
        }
        Integer color = Provider.getColor(light);
        if (color == null) {
            return;
        }
        double offset = 0.0;
        Block block = world.getBlock(x, y + 1, z);
        if (block != null && block.id() == Blocks.LAYER_SNOW.id()) {
            offset += block.getBlockBoundsFromState((WorldSource)world, (int)x, (int)(y + 1), (int)z).maxY;
        }
        this.cache.put(new Provider.Pos(x, y + 1, z), Pair.of((Object)offset, (Object)color));
    }

    @Override
    public void render(float partialTicks) {
        Minecraft minecraft = Minecraft.getMinecraft();
        ICamera camera = minecraft.activeCamera;
        if (camera == null) {
            return;
        }
        GL11.glPushMatrix();
        if ((Integer)Config.OVERLAY_TRANSPARENCY.getValue() < 100) {
            GL11.glEnable((int)3042);
        }
        GL11.glDisable((int)3553);
        if (LightmapHelper.isLightmapEnabled()) {
            Integer light = (Integer)Config.OVERLAY_BRIGHTNESS.getValue();
            LightmapHelper.setLightmapCoord((int)light, (int)light);
        }
        this.cache.forEach((pos, data) -> {
            double x = (double)pos.x + 0.44 - camera.getX(partialTicks);
            double y = (double)pos.y + (Double)data.getLeft() + 0.01 - camera.getY(partialTicks);
            double z = (double)pos.z + 0.562 - camera.getZ(partialTicks);
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)45.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glScalef((float)0.0890625f, (float)-0.0890625f, (float)0.0890625f);
            CrossMode.drawCross((Integer)data.getRight());
            GL11.glPopMatrix();
        });
        GL11.glEnable((int)3553);
        if ((Integer)Config.OVERLAY_TRANSPARENCY.getValue() < 100) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    private static void drawCross(int color) {
        GL11.glLineWidth((float)((Integer)Config.OVERLAY_LINE_THICKNESS.getValue()).intValue());
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(1);
        tessellator.setColorRGBA(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, (int)(2.55 * (double)((Integer)Config.OVERLAY_TRANSPARENCY.getValue()).intValue()));
        tessellator.addVertex(-8.0, 1.0, 0.0);
        tessellator.addVertex(8.0, 1.0, 0.0);
        tessellator.addVertex(0.0, -7.0, 0.0);
        tessellator.addVertex(0.0, 9.0, 0.0);
        tessellator.draw();
    }
}

