/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.mode;

import dev.schmarrn.lighty.api.LightyMode;
import dev.schmarrn.lighty.api.ModeManager;
import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.mode.Provider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.options.components.OptionsCategory;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;

public class CarpetMode
extends LightyMode<Provider.Pos, Pair<Double, Integer>> {
    private static final float TEXTURE_SIZE = 16.0f;

    public static void init() {
        ModeManager.registerMode("lighty.carpet_mode", new CarpetMode());
        ModeManager.addOptions(() -> new OptionsCategory("gui.modeSwitcher.lighty.carpet_mode").withComponent((OptionsComponent)Config.FLAT_CARPET.getOptionInstance()));
    }

    @Override
    public void compute(WorldClient world, int x, int y, int z) {
        if (Provider.isBlocked(x, y + 1, z, world)) {
            return;
        }
        Pair<Integer, Integer> light = Provider.compute(world, x, y, z);
        if (light == null) {
            return;
        }
        Integer color = Provider.getColor(light);
        if (color == null) {
            return;
        }
        double offset = 0.0;
        Block block = world.getBlock(x, y + 1, z);
        if (block != null && block.id() == Blocks.LAYER_SNOW.id()) {
            offset += block.getBlockBoundsFromState((WorldSource)world, (int)x, (int)(y + 1), (int)z).maxY;
        }
        this.cache.put(new Provider.Pos(x, y + 1, z), Pair.of((Object)offset, (Object)color));
    }

    private static boolean shouldRenderSideFace(int x, int y, int z, WorldClient world, double originalHeight) {
        Block block = world.getBlock(x, y, z);
        if (originalHeight > 0.0) {
            if (block != null && block.id() == Blocks.LAYER_SNOW.id()) {
                return originalHeight > block.getBlockBoundsFromState((WorldSource)world, (int)x, (int)y, (int)z).maxY;
            }
            return block == null;
        }
        return Provider.isBlocked(x, y, z, world);
    }

    @Override
    public void render(float partialTicks) {
        Minecraft minecraft = Minecraft.getMinecraft();
        ICamera camera = minecraft.activeCamera;
        if (camera == null) {
            return;
        }
        GL11.glPushMatrix();
        if ((Integer)Config.OVERLAY_TRANSPARENCY.getValue() < 100) {
            GL11.glEnable((int)3042);
        }
        if (LightmapHelper.isLightmapEnabled()) {
            Integer light = (Integer)Config.OVERLAY_BRIGHTNESS.getValue();
            LightmapHelper.setLightmapCoord((int)light, (int)light);
        }
        this.cache.forEach((pos, data) -> {
            double x = (double)pos.x - camera.getX(partialTicks);
            double y = (double)pos.y + (Double)data.getLeft() + 0.01 - camera.getY(partialTicks);
            double z = (double)pos.z - camera.getZ(partialTicks);
            GL11.glPushMatrix();
            Minecraft.getMinecraft().textureManager.loadTexture((String)Config.CARPET_TEXTURE.getValue()).bind();
            if (((Boolean)Config.FLAT_CARPET.getValue()).booleanValue()) {
                GL11.glTranslated((double)x, (double)y, (double)z);
                GL11.glScalef((float)0.0625f, (float)-0.0625f, (float)0.0625f);
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                CarpetMode.drawTexture(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 16.0f, 16.0f, (Integer)data.getRight());
            } else {
                GL11.glTranslated((double)x, (double)(y - 0.01), (double)z);
                GL11.glScalef((float)0.0625f, (float)-0.0625f, (float)0.0625f);
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                CarpetMode.drawTexture(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 16.0f, 16.0f, (Integer)data.getRight());
                WorldClient world = minecraft.currentWorld;
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                if (CarpetMode.shouldRenderSideFace(pos.x, pos.y, pos.z + 1, world, (Double)data.getLeft())) {
                    GL11.glPushMatrix();
                    CarpetMode.drawTexture(0.0f, -1.0f, 16.0f, 0.0f, 0.0f, 16.0f, 1.0f, (Integer)data.getRight());
                    GL11.glPopMatrix();
                }
                if (CarpetMode.shouldRenderSideFace(pos.x, pos.y, pos.z - 1, world, (Double)data.getLeft())) {
                    GL11.glPushMatrix();
                    GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                    CarpetMode.drawTexture(-16.0f, -1.0f, 0.0f, 0.0f, 0.0f, 16.0f, 1.0f, (Integer)data.getRight());
                    GL11.glPopMatrix();
                }
                if (CarpetMode.shouldRenderSideFace(pos.x + 1, pos.y, pos.z, world, (Double)data.getLeft())) {
                    GL11.glPushMatrix();
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    CarpetMode.drawTexture(-16.0f, -1.0f, 16.0f, 0.0f, 0.0f, 16.0f, 1.0f, (Integer)data.getRight());
                    GL11.glPopMatrix();
                }
                if (CarpetMode.shouldRenderSideFace(pos.x - 1, pos.y, pos.z, world, (Double)data.getLeft())) {
                    GL11.glPushMatrix();
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    CarpetMode.drawTexture(0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 16.0f, 1.0f, (Integer)data.getRight());
                    GL11.glPopMatrix();
                }
            }
            GL11.glPopMatrix();
        });
        if ((Integer)Config.OVERLAY_TRANSPARENCY.getValue() < 100) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    private static void drawTexture(float x, float y, float z, float u, float v, float width, float height, int color) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, (int)(2.55 * (double)((Integer)Config.OVERLAY_TRANSPARENCY.getValue()).intValue()));
        tessellator.addVertexWithUV((double)x, (double)(y + height), (double)z, (double)(u / 16.0f), (double)((v + height) / 16.0f));
        tessellator.addVertexWithUV((double)(x + width), (double)(y + height), (double)z, (double)((u + width) / 16.0f), (double)((v + height) / 16.0f));
        tessellator.addVertexWithUV((double)(x + width), (double)y, (double)z, (double)((u + width) / 16.0f), (double)(v / 16.0f));
        tessellator.addVertexWithUV((double)x, (double)y, (double)z, (double)(u / 16.0f), (double)(v / 16.0f));
        tessellator.draw();
    }
}

