/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.config;

import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.config.ConfigType;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.gui.options.components.ToggleableOptionComponent;
import net.minecraft.client.option.OptionRange;
import net.minecraft.client.option.OptionToggleable;

public class IntegerConfig
extends ConfigType<Integer> {
    private final int min;
    private final int max;

    public ButtonComponent getOptionInstance() {
        return new ToggleableOptionComponent((OptionToggleable)new OptionRange(null, this.getTranslationKey(), (Integer)this.getValue(), this.max + 1){

            public void onUpdate() {
                IntegerConfig.this.setValue((Integer)this.value);
            }

            public String getDisplayString() {
                return this.getDisplayStringValue();
            }

            public String getDisplayStringValue() {
                return IntegerConfig.this.getValue() + "";
            }
        });
    }

    public IntegerConfig(String key, Integer defaultValue, int min, int max) {
        super(key, defaultValue);
        this.min = min;
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public void setValue(Integer newValue) {
        if (newValue <= this.max) {
            super.setValue(Math.max(this.min, newValue));
        } else {
            Lighty.LOGGER.error("Lighty Config: {}, new value {} out of bounds: [{}, {}]. Ignoring new value.", new Object[]{this.getKey(), newValue, this.min, this.max});
        }
    }

    @Override
    String serialize() {
        return Integer.toString((Integer)this.getValue());
    }

    @Override
    void deserialize(String value) {
        this.setValue(Integer.valueOf(value));
    }
}

