/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.render.style;

import b100.minimap.Minimap;
import b100.minimap.render.style.MapStyle;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class MapStyleCustom
implements MapStyle {
    public boolean round;

    public MapStyleCustom(boolean round) {
        this.round = round;
    }

    public InputStream getInternalResource(String path) {
        InputStream stream = Minimap.class.getResourceAsStream(path);
        if (stream == null) {
            throw new NullPointerException("Resource doesn't exist: '" + path + "'!");
        }
        return stream;
    }

    public InputStream getResource(String path) {
        return Minimap.instance.minecraftHelper.getResource(path);
    }

    public BufferedImage getImage(String path) {
        InputStream stream = null;
        try {
            stream = this.getResource(path);
            BufferedImage bufferedImage = ImageIO.read(stream);
            return bufferedImage;
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading image: '" + path + "'", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public BufferedImage getMapTexture() {
        if (this.round) {
            return this.getImage("/assets/minimap/minimap/roundmap.png");
        }
        return this.getImage("/assets/minimap/minimap/squaremap.png");
    }

    @Override
    public BufferedImage getMaskTexture() {
        if (this.round) {
            return this.getImage("/assets/minimap/minimap/roundmap_mask.png");
        }
        return this.getImage("/assets/minimap/minimap/squaremap_mask.png");
    }

    @Override
    public boolean isRound() {
        return this.round;
    }

    @Override
    public boolean useLinearFiltering() {
        return false;
    }

    @Override
    public void closeStreams() {
    }
}

