/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.gui.Colors;
import b100.minimap.gui.GuiElement;
import b100.minimap.gui.GuiScreen;
import b100.minimap.gui.GuiTextComponent;
import org.lwjgl.opengl.GL11;

public class GuiTextField
extends GuiElement {
    public GuiScreen screen;
    public GuiTextComponent textComponent;

    public GuiTextField(GuiScreen screen, GuiTextComponent textComponent) {
        this.screen = screen;
        this.textComponent = textComponent;
        this.setSize(100, 10);
    }

    public GuiTextField(GuiScreen screen, String string) {
        this.screen = screen;
        this.textComponent = new GuiTextComponent(string);
        this.setSize(100, 10);
    }

    @Override
    public void draw(float partialTicks) {
        GL11.glDisable((int)3553);
        this.utils.drawRectangle(this.posX, this.posY, this.width, this.height, this.getBackgroundColor());
        this.textComponent.posX = this.posX + 2;
        this.textComponent.posY = this.posY + 1;
        this.textComponent.draw(partialTicks);
    }

    @Override
    public void keyEvent(int key, char c, boolean pressed, boolean repeat, int mouseX, int mouseY) {
        this.textComponent.keyEvent(key, c, pressed);
        super.keyEvent(key, c, pressed, repeat, mouseX, mouseY);
    }

    @Override
    public void mouseEvent(int button, boolean pressed, int mouseX, int mouseY) {
        if (pressed) {
            if (this.screen.getClickElementAt(mouseX, mouseY) == this) {
                if (button == 1) {
                    this.textComponent.setText("");
                }
                this.textComponent.setFocused(true);
            } else {
                this.textComponent.setFocused(false);
            }
        }
    }

    @Override
    public void scrollEvent(int dir, int mouseX, int mouseY) {
        this.textComponent.scrollEvent(dir);
        super.scrollEvent(dir, mouseX, mouseY);
    }

    public int getBackgroundColor() {
        return this.textComponent.focused ? Colors.buttonBackgroundHover : Colors.buttonBackground;
    }

    public String getText() {
        return this.textComponent.text;
    }
}

