/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.gui.Colors;
import b100.minimap.gui.GuiTextComponent;
import b100.minimap.utils.Utils;

public class GuiTextComponentColor
extends GuiTextComponent {
    private int value;
    private boolean isValid = true;
    private boolean includeAlpha;

    public GuiTextComponentColor(int color, boolean includeAlpha) {
        super(Utils.toColorString(color, includeAlpha));
        this.value = color;
        this.includeAlpha = includeAlpha;
    }

    public void setColor(int color) {
        this.setText(Utils.toColorString(color, this.includeAlpha));
    }

    public int getColor() {
        return this.value;
    }

    @Override
    public void onUpdate() {
        try {
            this.value = Utils.parseColor(this.text);
            this.isValid = true;
        }
        catch (NumberFormatException e) {
            this.isValid = false;
        }
        super.onUpdate();
    }

    @Override
    public int getTextColor() {
        return this.isValid ? super.getTextColor() : Colors.textInvalid;
    }
}

