/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.data;

import b100.minimap.Minimap;
import b100.minimap.mc.IDimension;
import b100.minimap.waypoint.Waypoint;
import com.b100.json.element.JsonArray;
import com.b100.json.element.JsonElement;
import com.b100.json.element.JsonObject;
import com.b100.utils.StringReader;
import com.b100.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.world.World;

public class WorldData {
    public File directory;
    public World world;
    public IDimension dimension;
    private List<Waypoint> waypoints = new ArrayList<Waypoint>();
    private boolean savingAll = false;

    public WorldData(File directory, World world) {
        this.directory = directory;
        this.world = world;
        this.dimension = Minimap.instance.minecraftHelper.getDimensionFromWorld(world);
    }

    public void load() {
        Minimap.log("Loading world data: '" + this.directory.getAbsolutePath() + "'");
        this.loadWaypoints();
    }

    public void save() {
        Minimap.log("Saving world data: '" + this.directory.getAbsolutePath() + "'");
        this.savingAll = true;
        this.directory.mkdirs();
        this.saveWaypoints();
        this.savingAll = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadWaypoints() {
        this.waypoints.clear();
        File waypointsFile = new File(this.directory, "waypoints.json");
        if (waypointsFile.exists()) {
            try {
                JsonObject jsonObject = new JsonObject(new StringReader(StringUtils.getFileContentAsString((File)waypointsFile)));
                JsonArray jsonArray = jsonObject.getArray("waypoints");
                if (jsonArray == null) return;
                for (JsonElement element : jsonArray) {
                    this.waypoints.add(new Waypoint(this, element.getAsObject()));
                }
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load waypoints from '" + waypointsFile.getAbsolutePath() + "'", e);
            }
        } else {
            Minimap.log("Waypoint file '" + waypointsFile.getAbsolutePath() + "' does not exist!");
        }
    }

    public void saveWaypoints() {
        File waypointsFile = new File(this.directory, "waypoints.json");
        File waypointsFileOld = new File(this.directory, "waypoints.json_old");
        if (waypointsFileOld.exists()) {
            waypointsFileOld.delete();
        }
        if (waypointsFile.exists()) {
            waypointsFile.renameTo(waypointsFileOld);
        }
        JsonArray array = new JsonArray(this.waypoints.size());
        for (int i = 0; i < this.waypoints.size(); ++i) {
            array.set(i, (JsonElement)this.waypoints.get(i).toJson());
        }
        JsonObject root = new JsonObject();
        root.set("waypoints", (JsonElement)array);
        StringUtils.saveStringToFile((File)waypointsFile, (String)root.toString());
        if (!this.savingAll) {
            Minimap.log("Saved waypoints to '" + waypointsFile.getAbsolutePath() + "'");
        }
    }

    public void addWaypoint(Waypoint waypoint) {
        this.waypoints.add(waypoint);
    }

    public boolean remove(Waypoint waypoint) {
        return this.waypoints.remove(waypoint);
    }

    public List<Waypoint> getWaypoints() {
        return this.waypoints;
    }
}

