/*
 * Decompiled with CFR 0.152.
 */
package gungun974.solidpacket.mixin;

import gungun974.solidpacket.BoundedInputStream;
import gungun974.solidpacket.SolidPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Set;
import net.minecraft.core.net.packet.Packet;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Packet.class}, remap=false)
public abstract class PacketMixin {
    @Shadow
    @Final
    private static Set serverBoundPacketIds;
    @Shadow
    @Final
    private static Set clientBoundPacketIds;
    @Unique
    private static final ThreadLocal<byte[]> readBuffer;
    @Unique
    private static final ThreadLocal<ByteArrayOutputStream> writeBuffer;

    @Unique
    private static void ensureReadCapacity(int minCapacity) {
        int oldCapacity = readBuffer.get().length;
        if (minCapacity > oldCapacity) {
            int newCapacity = PacketMixin.newLength(oldCapacity, minCapacity - oldCapacity, oldCapacity);
            readBuffer.set(new byte[newCapacity]);
        }
    }

    @Unique
    private static int newLength(int oldLength, int minGrowth, int prefGrowth) {
        int newLength = oldLength + Math.max(minGrowth, prefGrowth >> 1);
        if (newLength < 0) {
            throw new OutOfMemoryError("Array size too large");
        }
        return newLength;
    }

    @Inject(method={"readPacket"}, at={@At(value="HEAD")}, cancellable=true)
    private static void readPacket(DataInputStream dis, boolean isServer, CallbackInfoReturnable<Packet> cir) throws IOException {
        cir.cancel();
        try {
            boolean ok;
            int id = dis.read();
            if (id == -1) {
                cir.setReturnValue(null);
                return;
            }
            int length = dis.readInt();
            if (length < 0) {
                throw new IOException("Negative packet length " + length);
            }
            boolean bl = ok = !(isServer && !serverBoundPacketIds.contains(id) || !isServer && !clientBoundPacketIds.contains(id));
            if (!ok) {
                long n = length;
                while (n > 0L) {
                    long ns = dis.skip(n);
                    if (ns > 0L && ns <= n) {
                        n -= ns;
                        continue;
                    }
                    if (ns == 0L) {
                        if (dis.read() == -1) {
                            throw new EOFException();
                        }
                        --n;
                        continue;
                    }
                    throw new IOException("Unable to skip exactly");
                }
                throw new IOException("Bad packet id " + id);
            }
            if (SolidPacket.SCAN_AND_DUMP_LEFTOVER_PACKET) {
                PacketMixin.ensureReadCapacity(length);
                dis.readFully(readBuffer.get(), 0, length);
                ByteArrayInputStream bais = new ByteArrayInputStream(readBuffer.get());
                BoundedInputStream bin = new BoundedInputStream(bais, length);
                DataInputStream innerDis = new DataInputStream(bin);
                Packet packet = Packet.getNewPacket((int)id);
                if (packet == null) {
                    throw new IOException("Bad packet id " + id);
                }
                packet.read(innerDis);
                int leftover = bin.getRemaining();
                if (leftover > 0) {
                    byte[] dumpData = readBuffer.get();
                    StringBuilder dump = new StringBuilder();
                    dump.append(String.format("Packet id %d didn't read everything (%d bytes left)\n--- DUMP (len %d) ---\n", id, leftover, length));
                    String RED = "\u001b[31m";
                    String RESET = "\u001b[0m";
                    int unreadStart = length - leftover;
                    if (unreadStart < 0) {
                        unreadStart = length - leftover;
                    }
                    for (int i = 0; i < length; i += 16) {
                        dump.append(String.format("%04X: ", i));
                        StringBuilder ascii = new StringBuilder();
                        for (int j = 0; j < 16 && i + j < length; ++j) {
                            char c;
                            boolean isUnread;
                            int index = i + j;
                            byte b = dumpData[index];
                            boolean bl2 = isUnread = index >= unreadStart;
                            if (isUnread) {
                                dump.append("\u001b[31m");
                            }
                            dump.append(String.format("%02X ", b));
                            if (isUnread) {
                                dump.append("\u001b[0m");
                            }
                            char c2 = c = b >= 32 && b < 127 ? (char)b : (char)'.';
                            if (isUnread) {
                                ascii.append("\u001b[31m").append(c).append("\u001b[0m");
                                continue;
                            }
                            ascii.append(c);
                        }
                        int hexLen = (16 - Math.min(16, length - i)) * 3;
                        for (int s = 0; s < hexLen; ++s) {
                            dump.append(' ');
                        }
                        dump.append(" | ").append((CharSequence)ascii).append('\n');
                    }
                    dump.append("--- END OF DUMP ---\n");
                    SolidPacket.LOGGER.warn(dump.toString());
                }
                cir.setReturnValue((Object)packet);
            } else {
                BoundedInputStream bin = new BoundedInputStream(dis, length);
                DataInputStream innerDis = new DataInputStream(bin);
                Packet packet = Packet.getNewPacket((int)id);
                if (packet == null) {
                    throw new IOException("Bad packet id " + id);
                }
                packet.read(innerDis);
                int leftover = bin.getRemaining();
                if (leftover > 0) {
                    SolidPacket.LOGGER.warn("Packet id {} didn't read everything ({} bytes left)", (Object)id, (Object)leftover);
                }
                cir.setReturnValue((Object)packet);
            }
        }
        catch (EOFException eof) {
            SolidPacket.LOGGER.warn("PACKET: Reached end of stream");
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"writePacket"}, at={@At(value="HEAD")}, cancellable=true)
    private static void writePacket(Packet packet, DataOutputStream dos, CallbackInfo ci) throws IOException {
        ci.cancel();
        dos.write(packet.getId());
        writeBuffer.get().reset();
        DataOutputStream innerDos = new DataOutputStream(writeBuffer.get());
        packet.write(innerDos);
        dos.writeInt(writeBuffer.get().size());
        writeBuffer.get().writeTo(dos);
    }

    static {
        readBuffer = ThreadLocal.withInitial(() -> new byte[32]);
        writeBuffer = ThreadLocal.withInitial(ByteArrayOutputStream::new);
    }
}

