/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.config.IntegerOption;
import b100.minimap.config.Option;
import b100.minimap.gui.GuiOptionButton;
import b100.minimap.gui.GuiScreen;
import org.lwjgl.input.Keyboard;

public class GuiOptionButtonInteger
extends GuiOptionButton<Integer> {
    public IntegerOption integerOption;
    public boolean enableScrolling = true;

    public GuiOptionButtonInteger(GuiScreen screen, IntegerOption option) {
        super(screen, option);
        this.integerOption = option;
    }

    @Override
    public void onClick(int button) {
        if (button == 0) {
            this.update(1, true);
        }
        if (button == 1) {
            this.update(-1, true);
        }
    }

    @Override
    public void scrollEvent(int dir, int mouseX, int mouseY) {
        if (this.enableScrolling && this.screen.getClickElementAt(mouseX, mouseY) == this) {
            int scrollAmount = 0;
            if (dir > 0) {
                scrollAmount = 1;
            }
            if (dir < 0) {
                scrollAmount = -1;
            }
            if (Keyboard.isKeyDown((int)Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown((int)Keyboard.KEY_RCONTROL)) {
                scrollAmount *= 10;
            }
            this.update(scrollAmount, false);
        }
    }

    public void update(int delta, boolean loop) {
        Option option = this.option;
        option.value = (Integer)option.value + delta;
        if (this.integerOption.minValue == null || this.integerOption.maxValue == null) {
            loop = false;
        }
        if (this.integerOption.maxValue != null && (Integer)this.option.value > this.integerOption.maxValue) {
            this.option.value = loop ? this.integerOption.minValue : this.integerOption.maxValue;
        }
        if (this.integerOption.minValue != null && (Integer)this.option.value < this.integerOption.minValue) {
            this.option.value = loop ? this.integerOption.maxValue : this.integerOption.minValue;
        }
        this.onOptionValueChanged();
    }

    public GuiOptionButtonInteger setScrollingEnabled(boolean enableScrolling) {
        this.enableScrolling = enableScrolling;
        return this;
    }
}

