/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.config.MapConfig;
import b100.minimap.config.Option;
import b100.minimap.gui.GuiButtonNavigation;
import b100.minimap.gui.GuiNavigationContainer;
import b100.minimap.gui.GuiOptionButtonBoolean;
import b100.minimap.gui.GuiOptionButtonInteger;
import b100.minimap.gui.GuiOptionButtonMapStyle;
import b100.minimap.gui.GuiOptionsContainer;
import b100.minimap.gui.GuiScreen;
import b100.minimap.gui.OptionListener;

public class GuiConfigMap
extends GuiScreen
implements OptionListener {
    public GuiOptionsContainer options;
    public GuiNavigationContainer navTop;
    public GuiNavigationContainer navBottom;

    public GuiConfigMap(GuiScreen parentScreen) {
        super(parentScreen);
    }

    @Override
    public void onInit() {
        MapConfig config = this.minimap.config.mapConfig;
        this.options = this.add(new GuiOptionsContainer(this));
        this.options.add("Style", new GuiOptionButtonMapStyle((GuiScreen)this, config.mapStyle).addOptionListener(this));
        this.options.add("Fullscreen Map", new GuiOptionButtonBoolean((GuiScreen)this, config.fullscreenMap));
        this.options.add("Fullscreen Map Type", new GuiOptionButtonInteger((GuiScreen)this, config.fullscreenType));
        this.options.add("Round Map", new GuiOptionButtonBoolean((GuiScreen)this, config.roundMap).addOptionListener(this));
        this.options.add("Rotate Map", new GuiOptionButtonBoolean((GuiScreen)this, config.rotateMap));
        this.options.add("Rotate Frame", new GuiOptionButtonBoolean((GuiScreen)this, config.rotateFrame));
        this.options.add("Position", new GuiOptionButtonInteger((GuiScreen)this, config.position).setScrollingEnabled(false));
        this.options.add("Size", new GuiOptionButtonInteger((GuiScreen)this, config.width));
        this.options.add("Frame Opacity", new GuiOptionButtonInteger((GuiScreen)this, config.frameOpacity));
        this.options.add("Shade Type", new GuiOptionButtonInteger((GuiScreen)this, config.shadeType).setScrollingEnabled(false).addOptionListener(this));
        this.options.add("Lighting", new GuiOptionButtonBoolean((GuiScreen)this, config.lighting).addOptionListener(this));
        this.options.add("Show All Blocks", new GuiOptionButtonBoolean((GuiScreen)this, config.renderAllBlocks).addOptionListener(this));
        this.options.add("Show Waypoints", new GuiOptionButtonBoolean((GuiScreen)this, config.showWaypoints));
        this.options.add("Waypoint Labels", new GuiOptionButtonBoolean((GuiScreen)this, config.showWaypointLabels));
        this.options.add("Waypoint Label Size", new GuiOptionButtonInteger((GuiScreen)this, config.waypointLabelSize));
        this.navBottom = this.add(new GuiNavigationContainer(this, this.options, GuiNavigationContainer.Position.BOTTOM));
        this.navBottom.add(new GuiButtonNavigation(this, "Back", this.options).addActionListener(e -> this.back()));
        this.navTop = this.add(new GuiNavigationContainer(this, this.options, GuiNavigationContainer.Position.TOP));
        this.navTop.add(new GuiButtonNavigation(this, "Map Configuration", this.options));
    }

    @Override
    public void onOptionValueChanged(Option<?> option) {
        MapConfig mapConfig = this.minimap.config.mapConfig;
        if (option == mapConfig.shadeType || option == mapConfig.lighting || option == mapConfig.renderAllBlocks) {
            this.minimap.mapRender.updateAllTiles();
        }
        if (option == mapConfig.mapStyle || option == mapConfig.roundMap) {
            this.minimap.updateStyle();
        }
    }
}

