/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.examplemod.mixin;

import net.minecraft.client.option.GameSettings;
import net.minecraft.client.sound.SoundCategoryHelper;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.sound.SoundEntry;
import net.minecraft.client.sound.SoundEvent;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.core.sound.SoundCategory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import paulscode.sound.SoundSystem;
import turniplabs.examplemod.ExampleMod;

@Mixin(value={SoundEngine.class}, remap=false)
public class SoundEngineMixin {
    @Shadow
    private int ticksBeforeMusic;
    @Shadow
    private GameSettings options;
    private static SoundSystem soundSystem;

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void tickUpdate(CallbackInfo info) {
        if ((Integer)ExampleMod.music_start.value >= 1) {
            ExampleMod.music_start.value = 0;
            SoundEvent event = SoundRepository.SOUNDS.getRandomSoundFromCategory("music.");
            SoundEntry entry = event.getRandomEntry();
            if (entry != null) {
                this.ticksBeforeMusic = (Integer)ExampleMod.music_delay.value;
                soundSystem.backgroundMusic("BgMusic", entry.getURL(), entry.name, false);
                soundSystem.setPitch("BgMusic", entry.pitch);
                soundSystem.setVolume("BgMusic", SoundCategoryHelper.getEffectiveVolume((SoundCategory)SoundCategory.MUSIC, (GameSettings)this.options) * entry.volume);
                soundSystem.play("BgMusic");
            }
        }
        if ((Integer)ExampleMod.music_restart.value >= 1) {
            ExampleMod.music_restart.value = 0;
            soundSystem.stop("BgMusic");
        }
        if (ExampleMod.music_delay != null && this.ticksBeforeMusic > (Integer)ExampleMod.music_delay.value * 2) {
            this.ticksBeforeMusic = (Integer)ExampleMod.music_delay.value * 2;
        }
    }

    @ModifyConstant(method={"<init>"}, constant={@Constant(intValue=6000)})
    public int SoundEngineConstructor(int ___) {
        if (ExampleMod.music_delay != null) {
            return (Integer)ExampleMod.music_delay.value;
        }
        return 6000;
    }

    @ModifyConstant(method={"tick()V"}, constant={@Constant(intValue=6000)})
    public int tickConstant(int ___) {
        if (ExampleMod.music_delay != null) {
            return (Integer)ExampleMod.music_delay.value;
        }
        return 6000;
    }
}

