/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.util.toml;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.spongepowered.include.com.google.common.collect.ImmutableList;
import turniplabs.halplibe.util.toml.CommentedEntry;
import turniplabs.halplibe.util.toml.Entry;

public class Toml {
    protected HashMap<String, Toml> categories = new HashMap();
    protected HashMap<String, Entry<?>> entries = new HashMap();
    protected Optional<String> comment = Optional.empty();
    ArrayList<String> orderedKeys = new ArrayList();
    ImmutableList<String> immutKeys = null;

    public Object get(String key) {
        return this.get(key, Object.class);
    }

    public <T> T get(String key, Class<T> clazz) {
        if (key.startsWith(".")) {
            if (key.substring(1).contains(".")) {
                String[] split = key.substring(1).split("\\.", 2);
                return (T)this.categories.get(split[0]).get("." + split[1]);
            }
            return (T)this.categories.get(key.substring(1));
        }
        if (key.contains(".")) {
            String[] split = key.split("\\.", 2);
            return (T)this.categories.get(split[0]).get(split[1]);
        }
        Entry<?> entry = this.entries.get(key);
        if (entry == null) {
            return null;
        }
        Object value = entry.getT();
        if (value instanceof String) {
            if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
                return (T)Byte.valueOf(Byte.parseByte((String)value));
            }
            if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
                return (T)Short.valueOf(Short.parseShort((String)value));
            }
            if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(Integer.parseInt((String)value));
            }
            if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
                return (T)Long.valueOf(Long.parseLong((String)value));
            }
            if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
                return (T)Float.valueOf(Float.parseFloat((String)value));
            }
            if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
                return (T)Double.valueOf(Double.parseDouble((String)value));
            }
            if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                return (T)Boolean.valueOf(Boolean.parseBoolean((String)value));
            }
        } else {
            if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
                return (T)Float.valueOf(((Number)value).floatValue());
            }
            if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
                return (T)Double.valueOf(((Number)value).doubleValue());
            }
            if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
                return (T)Long.valueOf(((Number)value).longValue());
            }
            if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(((Number)value).intValue());
            }
            if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
                return (T)Short.valueOf(((Number)value).shortValue());
            }
            if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
                return (T)Byte.valueOf(((Number)value).byteValue());
            }
        }
        return (T)value;
    }

    public Entry<?> getEntry(String key) {
        if (key.startsWith(".")) {
            throw new RuntimeException("Categories are not entries");
        }
        return this.entries.get(key);
    }

    public Toml() {
    }

    public Toml(String comment) {
        this.comment = Optional.of(comment);
    }

    @CanIgnoreReturnValue
    public Toml addCategory(String comment, String name) {
        return this.addCategory(name, new Toml(comment));
    }

    @CanIgnoreReturnValue
    public Toml addCategory(String name) {
        return this.addCategory(name, new Toml());
    }

    protected Toml addCategory(String name, Toml category) {
        if (name.contains(".")) {
            String[] split = name.split("\\.", 2);
            Toml toml = this.categories.get(split[0]);
            if (toml == null) {
                toml = new Toml();
                this.categories.put(split[0], toml);
                this.orderedKeys.add("." + split[0]);
            }
            toml.addCategory(split[1], category);
        } else {
            this.orderedKeys.add("." + name);
            this.categories.put(name, category);
        }
        return category;
    }

    @CanIgnoreReturnValue
    public <T> Toml addEntry(String name, T value) {
        return this.addEntry(name, new Entry<T>(value));
    }

    @CanIgnoreReturnValue
    public <T> Toml addEntry(String name, String comment, T value) {
        return this.addEntry(name, (Entry<?>)new CommentedEntry<T>(comment, value));
    }

    public Toml addEntry(String name, Entry<?> value) {
        this.immutKeys = null;
        if (name.contains(".")) {
            String[] split = name.split("\\.", 2);
            Toml toml = this.categories.get(split[0]);
            if (toml == null) {
                toml = new Toml();
                this.categories.put(split[0], toml);
                this.orderedKeys.add("." + split[0]);
            }
            toml.addEntry(split[1], value);
        } else if (this.entries.put(name, value) == null) {
            this.orderedKeys.add(name);
        }
        return this;
    }

    public ImmutableList<String> getOrderedKeys() {
        if (this.immutKeys == null) {
            this.immutKeys = ImmutableList.builder().addAll(this.orderedKeys).build();
        }
        return this.immutKeys;
    }

    protected String repeat(String txt, int count) {
        StringBuilder dst = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            dst.append(txt);
        }
        return dst.toString();
    }

    public String toString(String rootKey, int indents) {
        StringBuilder builder = new StringBuilder();
        if (rootKey.isEmpty()) {
            if (this.comment.isPresent()) {
                String comment = this.comment.get();
                for (String re : comment.split("\n")) {
                    builder.append(this.repeat("\t", indents)).append("# ").append(re).append("\n");
                }
            }
            builder.append("\n");
        }
        for (String orderedKey : this.getOrderedKeys()) {
            String[] res;
            int offset = 0;
            int sep = 0;
            if (orderedKey.startsWith(".")) {
                if (orderedKey.substring(1).contains(".")) continue;
                Toml cat = this.categories.get(orderedKey.substring(1));
                String full = rootKey + (rootKey.isEmpty() ? "" : ".") + orderedKey.substring(1);
                if (cat.comment.isPresent()) {
                    String comment = cat.comment.get();
                    for (String re : comment.split("\n")) {
                        builder.append(this.repeat("\t", indents)).append("# ").append(re).append("\n");
                    }
                }
                builder.append(this.repeat("\t", indents)).append("[").append(full).append("]").append("\n");
                res = cat.toString(full, 0).split("\n");
                offset = 1;
                sep = 1;
            } else {
                res = this.entries.get(orderedKey).toString(orderedKey).split("\n");
            }
            for (String re : res) {
                builder.append(this.repeat("\t", indents + offset)).append(re).append("\n");
            }
            builder.append(this.repeat("\n", sep));
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString("", 0);
    }

    public boolean contains(String entry) {
        return this.get(entry) != null;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public void merge(boolean complete, Toml parsed) {
        for (String orderedKey : parsed.orderedKeys) {
            if (orderedKey.startsWith(".")) {
                orderedKey = orderedKey.substring(1);
                if (complete) {
                    if (!this.categories.containsKey(orderedKey)) {
                        this.addCategory(orderedKey);
                    }
                    this.categories.get(orderedKey).merge(complete, parsed.categories.get(orderedKey));
                    continue;
                }
                if (!this.categories.containsKey(orderedKey)) continue;
                this.categories.get(orderedKey).merge(complete, parsed.categories.get(orderedKey));
                continue;
            }
            if (complete) {
                if (this.entries.containsKey(orderedKey)) {
                    Entry<?> entry = this.entries.get(orderedKey);
                    if (entry instanceof CommentedEntry) {
                        this.entries.replace(orderedKey, new CommentedEntry(((CommentedEntry)entry).getComment(), parsed.getEntry((String)orderedKey).t));
                        continue;
                    }
                    this.entries.replace(orderedKey, parsed.getEntry(orderedKey));
                    continue;
                }
                this.entries.replace(orderedKey, parsed.getEntry(orderedKey));
                continue;
            }
            if (this.entries.containsKey(orderedKey)) continue;
            this.entries.replace(orderedKey, parsed.getEntry(orderedKey));
        }
    }

    public void merge(Toml parsed) {
        this.merge(false, parsed);
    }

    public void addMissing(Toml other) {
        for (String orderedKey : other.getOrderedKeys()) {
            if (orderedKey.startsWith(".")) {
                if (this.categories.containsKey(orderedKey)) continue;
                Toml toml = other.get(orderedKey, Toml.class);
                if (toml.getComment().isPresent()) {
                    this.addCategory(toml.getComment().get(), orderedKey.substring(1));
                } else {
                    this.addCategory(orderedKey.substring(1));
                }
                this.categories.get(orderedKey.substring(1)).addMissing(toml);
                continue;
            }
            if (this.entries.containsKey(orderedKey)) continue;
            this.addEntry(orderedKey, other.getEntry(orderedKey));
        }
    }

    public void remove(String s) {
        this.immutKeys = null;
        if (s.startsWith(".")) {
            if (s.substring(1).contains(".")) {
                this.categories.get(s.substring(1).split("\\.")[0]).remove("." + s.substring(1).split("\\.")[1]);
                return;
            }
            this.orderedKeys.remove(s);
            this.categories.remove(s.substring(1));
        } else {
            if (s.contains(".")) {
                this.categories.get(s.split("\\.")[0]).remove(s.split("\\.")[1]);
                return;
            }
            this.orderedKeys.remove(s);
            this.entries.remove(s);
        }
    }
}

