/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.client.render.texture.stitcher.AtlasStitcher;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import turniplabs.halplibe.HalpLibe;

public class TextureHelper {
    public static void initializeAllFiles(String modId, AtlasStitcher atlas, int depth) {
        Optional modContainer = FabricLoader.getInstance().getModContainer(modId);
        if (!modContainer.isPresent()) {
            HalpLibe.LOGGER.error("Failed to find mod {} when loading textures!", (Object)modId);
            return;
        }
        String path = String.format("%s/%s/%s", "assets", modId, atlas.directoryPath);
        String atlasKey = (String)TextureRegistry.stitcherMapReverse.get(atlas);
        Optional optionalPath = ((ModContainer)modContainer.get()).findPath(path);
        if (!optionalPath.isPresent()) {
            HalpLibe.LOGGER.error("Failed to find path to {}! [{}]", (Object)path, (Object)modId);
            return;
        }
        Path p = (Path)optionalPath.get();
        try (Stream<Path> stream = Files.walk(p, depth, new FileVisitOption[0]);){
            List paths = stream.collect(Collectors.toList());
            for (Path filePath : paths) {
                if (!TextureHelper.isPNG(filePath)) continue;
                String fileName = p.relativize(filePath).toString().replace(".png", "").replaceAll("\\\\", "/");
                String formatted = String.format("%s:%s/%s", modId, atlasKey, fileName);
                TextureRegistry.getTexture((String)formatted);
            }
        }
        catch (IOException e) {
            HalpLibe.LOGGER.error("Failed to initialize textures!", (Throwable)e);
        }
    }

    public static void initializeAllFiles(String modId, AtlasStitcher atlas) {
        TextureHelper.initializeAllFiles(modId, atlas, 1);
    }

    public static boolean isPNG(Path p) {
        try {
            String cType = Files.probeContentType(p);
            return cType != null && cType.equals("image/png");
        }
        catch (IOException e) {
            return false;
        }
    }
}

