/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper;

import com.b100.utils.FileUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Global;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeGroup;
import net.minecraft.core.data.registry.recipe.RecipeNamespace;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.adapter.ItemStackJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.RecipeSymbolJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.WeightedRandomBagJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.WeightedRandomLootObjectJsonAdapter;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.ItemStack;
import org.jspecify.annotations.NonNull;
import turniplabs.halplibe.helper.recipeBuilders.RecipeBuilderBlastFurnace;
import turniplabs.halplibe.helper.recipeBuilders.RecipeBuilderFurnace;
import turniplabs.halplibe.helper.recipeBuilders.RecipeBuilderShaped;
import turniplabs.halplibe.helper.recipeBuilders.RecipeBuilderShapeless;
import turniplabs.halplibe.helper.recipeBuilders.RecipeBuilderTrommel;
import turniplabs.halplibe.helper.recipeBuilders.modifiers.BlastFurnaceModifier;
import turniplabs.halplibe.helper.recipeBuilders.modifiers.FurnaceModifier;
import turniplabs.halplibe.helper.recipeBuilders.modifiers.TrommelModifier;
import turniplabs.halplibe.helper.recipeBuilders.modifiers.WorkbenchModifier;

public final class RecipeBuilder {
    public static boolean isExporting = false;

    public static void initNameSpace(String modID) {
        RecipeBuilder.getRecipeNamespace(modID);
        RecipeBuilder.getRecipeGroup(modID, "blast_furnace", new RecipeSymbol(Blocks.FURNACE_BLAST_ACTIVE.getDefaultStack()));
        RecipeBuilder.getRecipeGroup(modID, "furnace", new RecipeSymbol(Blocks.FURNACE_STONE_ACTIVE.getDefaultStack()));
        RecipeBuilder.getRecipeGroup(modID, "workbench", new RecipeSymbol(Blocks.WORKBENCH.getDefaultStack()));
        RecipeBuilder.getRecipeGroup(modID, "trommel", new RecipeSymbol(Blocks.TROMMEL_ACTIVE.getDefaultStack()));
    }

    public static @NonNull RecipeNamespace getRecipeNamespace(String modID) {
        if (Registries.RECIPES.getItem(modID) != null) {
            return (RecipeNamespace)Registries.RECIPES.getItem(modID);
        }
        RecipeNamespace modSpace = new RecipeNamespace();
        Registries.RECIPES.register(modID, modSpace);
        return Objects.requireNonNull(modSpace);
    }

    public static @NonNull RecipeGroup<?> getRecipeGroup(String modID, String key, RecipeSymbol symbol) {
        return RecipeBuilder.getRecipeGroup(RecipeBuilder.getRecipeNamespace(modID), key, symbol);
    }

    public static @NonNull RecipeGroup<?> getRecipeGroup(RecipeNamespace namespace, String key, RecipeSymbol symbol) {
        if (namespace.getItem(key) != null) {
            return (RecipeGroup)namespace.getItem(key);
        }
        RecipeGroup group = new RecipeGroup(symbol);
        namespace.register(key, (Object)group);
        return Objects.requireNonNull(group);
    }

    public static @NonNull List<ItemStack> getItemGroup(String modID, String key) {
        ArrayList group = (ArrayList)Registries.ITEM_GROUPS.getItem(String.format("%s:%s", modID, key));
        if (group == null) {
            group = new ArrayList();
            Registries.ITEM_GROUPS.register(String.format("%s:%s", modID, key), group);
        }
        return group;
    }

    public static void addItemsToGroup(String modID, String key, Object ... items) {
        List<ItemStack> group = RecipeBuilder.getItemGroup(modID, key);
        for (Object o : items) {
            if (o instanceof IItemConvertible) {
                group.add(((IItemConvertible)o).getDefaultStack());
                continue;
            }
            if (o instanceof ItemStack) {
                group.add((ItemStack)o);
                continue;
            }
            throw new IllegalArgumentException(String.format("Object '%s' has invalid class '%s'! Only classes that extend 'IItemConvertible' or 'ItemStack' are allowed!", o.toString(), o.getClass().getSimpleName()));
        }
    }

    public static RecipeBuilderShaped Shaped(String modID) {
        return new RecipeBuilderShaped(modID);
    }

    public static RecipeBuilderShaped Shaped(String modID, String ... shape) {
        return new RecipeBuilderShaped(modID, shape);
    }

    public static RecipeBuilderShapeless Shapeless(String modID) {
        return new RecipeBuilderShapeless(modID);
    }

    public static RecipeBuilderFurnace Furnace(String modID) {
        return new RecipeBuilderFurnace(modID);
    }

    public static RecipeBuilderBlastFurnace BlastFurnace(String modID) {
        return new RecipeBuilderBlastFurnace(modID);
    }

    public static RecipeBuilderTrommel Trommel(String modID) {
        return new RecipeBuilderTrommel(modID);
    }

    public static TrommelModifier ModifyTrommel(String namespace, String key) {
        return new TrommelModifier(namespace, key);
    }

    public static WorkbenchModifier ModifyWorkbench(String namespace) {
        return new WorkbenchModifier(namespace);
    }

    public static FurnaceModifier ModifyFurnace(String namespace) {
        return new FurnaceModifier(namespace);
    }

    public static BlastFurnaceModifier ModifyBlastFurnace(String namespace) {
        return new BlastFurnaceModifier(namespace);
    }

    public static void exportRecipes() {
        isExporting = true;
        Path filePath = Paths.get(Global.accessor.getMinecraftDir() + "/recipeDump", new String[0]);
        RecipeBuilder.createDir(filePath);
        String path = filePath + "/recipes.json";
        List recipes = Registries.RECIPES.getAllSerializableRecipes();
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        ArrayList<RecipeJsonAdapter> usedAdapters = new ArrayList<RecipeJsonAdapter>();
        for (RecipeEntryBase recipe : recipes) {
            HasJsonAdapter hasJsonAdapter = (HasJsonAdapter)recipe;
            RecipeJsonAdapter recipeJsonAdapter = hasJsonAdapter.getAdapter();
            if (usedAdapters.contains(recipeJsonAdapter)) continue;
            builder.registerTypeAdapter(recipe.getClass(), (Object)recipeJsonAdapter);
            usedAdapters.add(recipeJsonAdapter);
        }
        builder.registerTypeAdapter(ItemStack.class, (Object)new ItemStackJsonAdapter());
        builder.registerTypeAdapter(RecipeSymbol.class, (Object)new RecipeSymbolJsonAdapter());
        builder.registerTypeAdapter(new TypeToken<WeightedRandomBag<WeightedRandomLootObject>>(){}.getType(), (Object)new WeightedRandomBagJsonAdapter());
        builder.registerTypeAdapter(WeightedRandomLootObject.class, (Object)new WeightedRandomLootObjectJsonAdapter());
        Gson gson = builder.create();
        JsonArray jsonArray = new JsonArray();
        for (RecipeEntryBase recipeEntryBase : recipes) {
            TypeAdapter typeAdapter = gson.getAdapter(recipeEntryBase.getClass());
            JsonElement json = typeAdapter.toJsonTree((Object)recipeEntryBase);
            jsonArray.add(json);
        }
        File file = FileUtils.createNewFile((File)new File(path));
        try (FileWriter fileWriter = new FileWriter(file);){
            gson.toJson((JsonElement)jsonArray, (Appendable)fileWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        isExporting = false;
    }

    private static void createDir(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create directory!" + e.getMessage());
        }
    }
}

