/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.item.Item;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public final class ItemBuilder
implements Cloneable {
    private final String modId;
    private @Nullable String overrideKey = null;
    private @Nullable String textureKey = null;
    private @Nullable Tag<Item>[] tags = null;
    private Integer stackSize = null;
    private Integer maxDamage = null;
    private @Nullable Supplier<Item> containerItemSupplier = null;

    public ItemBuilder(String modId) {
        this.modId = modId;
    }

    public ItemBuilder clone() {
        try {
            return (ItemBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public ItemBuilder setKey(String key) {
        ItemBuilder builder = this.clone();
        builder.overrideKey = key;
        return builder;
    }

    public ItemBuilder setStackSize(int stackSize) {
        ItemBuilder builder = this.clone();
        builder.stackSize = stackSize;
        return builder;
    }

    public ItemBuilder setMaxDamage(int maxDamage) {
        ItemBuilder builder = this.clone();
        builder.maxDamage = maxDamage;
        return builder;
    }

    public ItemBuilder setContainerItem(Supplier<Item> itemSupplier) {
        ItemBuilder builder = this.clone();
        builder.containerItemSupplier = itemSupplier;
        return builder;
    }

    @SafeVarargs
    public final ItemBuilder setTags(Tag<Item> ... tags) {
        ItemBuilder itemBuilder = this.clone();
        itemBuilder.tags = tags;
        return itemBuilder;
    }

    @SafeVarargs
    public final ItemBuilder addTags(Tag<Item> ... tags) {
        ItemBuilder itemBuilder = this.clone();
        itemBuilder.tags = (Tag[])ArrayUtils.addAll((Object[])this.tags, (Object[])tags);
        return itemBuilder;
    }

    public <T extends Item> T build(T item) {
        List tokens = this.overrideKey != null ? Arrays.stream(this.overrideKey.split("\\.")).collect(Collectors.toList()) : Arrays.stream(item.getKey().split("\\.")).collect(Collectors.toList());
        if (this.tags != null) {
            item.withTags(this.tags);
        }
        if (this.stackSize != null) {
            item.setMaxStackSize(this.stackSize.intValue());
        }
        if (this.containerItemSupplier != null) {
            item.setContainerItem(this.containerItemSupplier.get());
        }
        if (this.maxDamage != null) {
            item.setMaxDamage(this.maxDamage.intValue());
        }
        ArrayList<String> newTokens = new ArrayList<String>();
        newTokens.add(this.modId);
        newTokens.addAll(tokens.subList(1, tokens.size()));
        item.setKey(StringUtils.join(newTokens, (String)"."));
        return item;
    }
}

