/*
 * Decompiled with CFR 0.152.
 */
package lunaticuncle.btalightoverlay.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.render.Font;
import net.minecraft.core.lang.I18n;

public class TextBoxComponent
implements OptionsComponent {
    private static final Minecraft mc = Minecraft.getMinecraft();
    private final TextFieldElement textField;
    private final String translationKey;

    public TextBoxComponent(String translationKey, String placeholder) {
        this.textField = new TextFieldElement(null, TextBoxComponent.mc.font, 0, 0, 120, 18, "", placeholder);
        this.textField.setMaxStringLength(20);
        this.translationKey = translationKey;
    }

    public int getHeight() {
        return 4 + this.textField.height + 4;
    }

    public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        Font fontRenderer = TextBoxComponent.mc.font;
        String translated = I18n.getInstance().translateKey(this.translationKey);
        int textColor = -1;
        if (relativeMouseX >= 0 && relativeMouseX <= width && relativeMouseY >= 2 && relativeMouseY <= this.getHeight() - 2) {
            textColor = -96;
        }
        fontRenderer.drawStringWithShadow(translated, x, y + this.getHeight() / 2 - 4, textColor);
        this.textField.xPosition = x + width - this.textField.width - 1;
        this.textField.yPosition = y + 4;
        this.textField.drawTextBox();
    }

    public void tick() {
        this.textField.updateCursorCounter();
    }

    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        this.textField.setFocused(relativeMouseX >= width - 120 && relativeMouseX <= width && relativeMouseY >= 2 && relativeMouseY <= 22);
    }

    public void onMouseMove(int i, int j, int k, int l, int m) {
    }

    public void onMouseRelease(int i, int j, int k, int l, int m, int n) {
    }

    public void onKeyPress(int keyCode, char character) {
        if (this.textField.isFocused && keyCode != 1) {
            this.textField.textboxKeyTyped(character, keyCode);
        } else if (keyCode == 1) {
            this.textField.setFocused(false);
        }
    }

    public boolean matchesSearchTerm(String term) {
        return I18n.getInstance().translateKey(this.translationKey).toLowerCase().contains(term.toLowerCase());
    }
}

