/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.collections;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ObjectWrapper<T> {
    protected List<ValueListener<T>> listeners = new ArrayList<ValueListener<T>>();
    protected T value;

    public ObjectWrapper(T initialValue) {
        this.value = initialValue;
    }

    public void set(T value) {
        this.value = value;
        for (ValueListener<T> listener : this.listeners) {
            listener.onValueChanged(value);
        }
    }

    public T get() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectWrapper that = (ObjectWrapper)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public ObjectWrapper<T> addChangeListener(@NotNull ValueListener<T> listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
        return this;
    }

    public static interface ValueListener<T> {
        public void onValueChanged(T var1);
    }
}

