/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AILogStreamCallback;
import org.lwjgl.assimp.AILogStreamCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiLogStream")
public class AILogStream
extends Struct<AILogStream>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CALLBACK;
    public static final int USER;

    protected AILogStream(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected AILogStream create(long address, @Nullable ByteBuffer container) {
        return new AILogStream(address, container);
    }

    public AILogStream(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AILogStream.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="aiLogStreamCallback")
    public AILogStreamCallback callback() {
        return AILogStream.ncallback(this.address());
    }

    @Nullable
    @NativeType(value="char *")
    public ByteBuffer user(int capacity) {
        return AILogStream.nuser(this.address(), capacity);
    }

    public AILogStream callback(@NativeType(value="aiLogStreamCallback") AILogStreamCallbackI value) {
        AILogStream.ncallback(this.address(), value);
        return this;
    }

    public AILogStream user(@Nullable @NativeType(value="char *") ByteBuffer value) {
        AILogStream.nuser(this.address(), value);
        return this;
    }

    public AILogStream set(AILogStreamCallbackI callback, @Nullable ByteBuffer user) {
        this.callback(callback);
        this.user(user);
        return this;
    }

    public AILogStream set(AILogStream src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AILogStream malloc() {
        return new AILogStream(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static AILogStream calloc() {
        return new AILogStream(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static AILogStream create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new AILogStream(MemoryUtil.memAddress(container), container);
    }

    public static AILogStream create(long address) {
        return new AILogStream(address, null);
    }

    @Nullable
    public static AILogStream createSafe(long address) {
        return address == 0L ? null : new AILogStream(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(AILogStream.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AILogStream.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AILogStream mallocStack() {
        return AILogStream.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AILogStream callocStack() {
        return AILogStream.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AILogStream mallocStack(MemoryStack stack) {
        return AILogStream.malloc(stack);
    }

    @Deprecated
    public static AILogStream callocStack(MemoryStack stack) {
        return AILogStream.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AILogStream.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AILogStream.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AILogStream.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AILogStream.calloc(capacity, stack);
    }

    public static AILogStream malloc(MemoryStack stack) {
        return new AILogStream(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AILogStream calloc(MemoryStack stack) {
        return new AILogStream(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AILogStreamCallback ncallback(long struct) {
        return AILogStreamCallback.create(MemoryUtil.memGetAddress(struct + (long)CALLBACK));
    }

    @Nullable
    public static ByteBuffer nuser(long struct, int capacity) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)USER), capacity);
    }

    public static void ncallback(long struct, AILogStreamCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CALLBACK, value.address());
    }

    public static void nuser(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)USER, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CALLBACK));
    }

    static {
        Struct.Layout layout = AILogStream.__struct(AILogStream.__member(POINTER_SIZE), AILogStream.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CALLBACK = layout.offsetof(0);
        USER = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AILogStream, Buffer>
    implements NativeResource {
        private static final AILogStream ELEMENT_FACTORY = AILogStream.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AILogStream getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="aiLogStreamCallback")
        public AILogStreamCallback callback() {
            return AILogStream.ncallback(this.address());
        }

        @Nullable
        @NativeType(value="char *")
        public ByteBuffer user(int capacity) {
            return AILogStream.nuser(this.address(), capacity);
        }

        public Buffer callback(@NativeType(value="aiLogStreamCallback") AILogStreamCallbackI value) {
            AILogStream.ncallback(this.address(), value);
            return this;
        }

        public Buffer user(@Nullable @NativeType(value="char *") ByteBuffer value) {
            AILogStream.nuser(this.address(), value);
            return this;
        }
    }
}

