/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.tree;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTree;

public class WorldFeatureTreeEucalyptus
extends WorldFeature {
    Random random;
    World world;
    int[] origin = new int[]{0, 0, 0};
    int height = 0;
    int trunkHeight;
    double trunkHeightScale = 0.381;
    double branchDensity = 1.0;
    double branchSlop = 0.381;
    double widthScale = 1.0;
    double foliageDensity = 1.0;
    int trunkWidth = 1;
    int heightVariance = 20;
    int foliageHeight = 10;
    int[][] foliageCoords;
    protected int leavesID;
    protected int logID;
    static final byte[] axisConversionArray = new byte[]{2, 0, 0, 1, 2, 1};

    @MethodParametersAnnotation(names={"leavesID", "logID"})
    public WorldFeatureTreeEucalyptus(int leavesID, int logID) {
        this.random = new Random();
        this.leavesID = leavesID;
        this.logID = logID;
    }

    void prepare() {
        int i;
        this.trunkHeight = (int)((double)this.height * this.trunkHeightScale);
        if (this.trunkHeight >= this.height) {
            this.trunkHeight = this.height - 1;
        }
        if ((i = (int)(1.381 + Math.pow(this.foliageDensity * (double)this.height / 7.0, 2.0))) < 1) {
            i = 1;
        }
        int[][] ai = new int[i * this.height][4];
        int j = this.origin[1] + this.height - this.foliageHeight;
        int k = 1;
        int l = this.origin[1] + this.trunkHeight;
        int i1 = j - this.origin[1];
        ai[0][0] = this.origin[0];
        ai[0][1] = j--;
        ai[0][2] = this.origin[2];
        ai[0][3] = l;
        while (i1 >= 0) {
            float treeShape = this.treeShape(i1);
            if (treeShape < 0.0f) {
                --j;
                --i1;
                continue;
            }
            double d = 0.5;
            for (int j1 = 0; j1 < i; ++j1) {
                int[] ai2;
                int l1;
                double d2;
                double d1 = this.widthScale * ((double)treeShape * ((double)this.random.nextFloat() + 0.328));
                int k1 = MathHelper.floor(d1 * Math.sin(d2 = (double)this.random.nextFloat() * 2.0 * 3.14159) + (double)this.origin[0] + d);
                int[] ai1 = new int[]{k1, j, l1 = MathHelper.floor(d1 * Math.cos(d2) + (double)this.origin[2] + d)};
                if (this.checkLine(ai1, ai2 = new int[]{k1, j + this.foliageHeight, l1}) != -1) continue;
                int[] ai3 = new int[]{this.origin[0], this.origin[1], this.origin[2]};
                double d3 = Math.sqrt(Math.pow(Math.abs(this.origin[0] - ai1[0]), 2.0) + Math.pow(Math.abs(this.origin[2] - ai1[2]), 2.0));
                double d4 = d3 * this.branchSlop;
                ai3[1] = (double)ai1[1] - d4 > (double)l ? l : (int)((double)ai1[1] - d4);
                if (this.checkLine(ai3, ai1) != -1) continue;
                ai[k][0] = k1;
                ai[k][1] = j;
                ai[k][2] = l1;
                ai[k][3] = ai3[1];
                ++k;
            }
            --j;
            --i1;
        }
        this.foliageCoords = new int[k][4];
        System.arraycopy(ai, 0, this.foliageCoords, 0, k);
    }

    void crossSection(int x, int y, int z, float f, byte byte0, int l) {
        int i1 = (int)((double)f + 0.618);
        byte byte1 = axisConversionArray[byte0];
        byte byte2 = axisConversionArray[byte0 + 3];
        int[] ai = new int[]{x, y, z};
        int[] ai1 = new int[]{0, 0, 0};
        int k1 = -i1;
        ai1[byte0] = ai[byte0];
        for (int j1 = -i1; j1 <= i1; ++j1) {
            ai1[byte1] = ai[byte1] + j1;
            int l1 = -i1;
            while (l1 <= i1) {
                double d = Math.sqrt(Math.pow((double)Math.abs(j1) + 0.5, 4.0) + Math.pow((double)Math.abs(l1) + 0.5, 4.0));
                if (d > (double)f) {
                    ++l1;
                    continue;
                }
                ai1[byte2] = ai[byte2] + l1;
                int i2 = this.world.getBlockId(ai1[0], ai1[1], ai1[2]);
                if (i2 != 0 && i2 != this.leavesID) {
                    ++l1;
                    continue;
                }
                this.world.setBlockWithNotify(ai1[0], ai1[1], ai1[2], l);
                ++l1;
            }
        }
    }

    float treeShape(int i) {
        if ((double)i < (double)this.height * 0.3) {
            return -1.618f;
        }
        float f = (float)this.height / 2.0f;
        float f1 = (float)this.height / 2.0f - (float)i;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f1), 2.0)));
        return f2 *= 0.5f;
    }

    float foliageShape(int i) {
        if (i < 0 || i >= this.foliageHeight) {
            return -1.0f;
        }
        return i != 0 && i != this.foliageHeight - 1 ? 3.0f : 2.0f;
    }

    void foliageCluster(int x, int y, int z) {
        int i1 = y + this.foliageHeight;
        for (int l = y; l < i1; ++l) {
            this.crossSection(x, l, z, this.foliageShape(l - y), (byte)1, this.leavesID);
        }
    }

    void makeFoliage() {
        int j = this.foliageCoords.length;
        for (int i = 0; i < j; ++i) {
            int x = this.foliageCoords[i][0];
            int y = this.foliageCoords[i][1];
            int z = this.foliageCoords[i][2];
            this.foliageCluster(x, y, z);
        }
    }

    void limb(int[] ai, int[] ai1, int i) {
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return;
        }
        byte byte1 = axisConversionArray[j];
        byte byte2 = axisConversionArray[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.floor((double)(ai[j] + k) + 0.5);
            ai3[byte1] = MathHelper.floor((double)ai[byte1] + (double)k * d + 0.5);
            ai3[byte2] = MathHelper.floor((double)ai[byte2] + (double)k * d1 + 0.5);
            this.world.setBlockWithNotify(ai3[0], ai3[1], ai3[2], i);
        }
    }

    boolean trimBranches(int i) {
        return (double)i >= (double)this.height * 0.2;
    }

    void makeTrunk() {
        int x = this.origin[0];
        int y = this.origin[1];
        int yTop = this.origin[1] + this.trunkHeight;
        int z = this.origin[2];
        int[] posBottom = new int[]{x, y, z};
        int[] posTop = new int[]{x, yTop, z};
        this.limb(posBottom, posTop, this.logID);
        if (this.trunkWidth == 2) {
            posBottom[0] = posBottom[0] + 1;
            posTop[0] = posTop[0] + 1;
            this.limb(posBottom, posTop, this.logID);
            posBottom[2] = posBottom[2] + 1;
            posTop[2] = posTop[2] + 1;
            this.limb(posBottom, posTop, this.logID);
            posBottom[0] = posBottom[0] - 1;
            posTop[0] = posTop[0] - 1;
            this.limb(posBottom, posTop, this.logID);
        }
    }

    void makeBranches() {
        int j = this.foliageCoords.length;
        int[] ai = new int[]{this.origin[0], this.origin[1], this.origin[2]};
        for (int i = 0; i < j; ++i) {
            int[] ai1 = this.foliageCoords[i];
            int[] ai2 = new int[]{ai1[0], ai1[1], ai1[2]};
            ai[1] = ai1[3];
            int k = ai[1] - this.origin[1];
            if (!this.trimBranches(k)) continue;
            this.limb(ai, ai2, this.logID);
        }
    }

    int checkLine(int[] ai, int[] ai1) {
        int j;
        int[] ai2 = new int[]{0, 0, 0};
        int i = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[i])) continue;
            i = byte0;
        }
        if (ai2[i] == 0) {
            return -1;
        }
        byte byte1 = axisConversionArray[i];
        byte byte2 = axisConversionArray[i + 3];
        int byte3 = ai2[i] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[i];
        double d1 = (double)ai2[byte2] / (double)ai2[i];
        int[] ai3 = new int[]{0, 0, 0};
        int k = ai2[i] + byte3;
        for (j = 0; j != k; j += byte3) {
            ai3[i] = ai[i] + j;
            ai3[byte1] = MathHelper.floor((double)ai[byte1] + (double)j * d);
            ai3[byte2] = MathHelper.floor((double)ai[byte2] + (double)j * d1);
            int l = this.world.getBlockId(ai3[0], ai3[1], ai3[2]);
            if (l != 0 && l != this.leavesID) break;
        }
        if (j == k) {
            return -1;
        }
        return Math.abs(j);
    }

    boolean checkLocation() {
        int[] ai = new int[]{this.origin[0], this.origin[1], this.origin[2]};
        int[] ai1 = new int[]{this.origin[0], this.origin[1] + this.height - 1, this.origin[2]};
        int idBelow = this.world.getBlockId(this.origin[0], this.origin[1] - 1, this.origin[2]);
        if (!Blocks.hasTag(idBelow, BlockTags.GROWS_TREES)) {
            return false;
        }
        int j = this.checkLine(ai, ai1);
        if (j == -1) {
            return true;
        }
        if (j < 6) {
            return false;
        }
        this.height = j;
        return true;
    }

    @Override
    public void init(double d, double d1, double d2) {
        this.heightVariance = (int)(d * 20.0);
        if (d > 0.5) {
            this.foliageHeight = 5;
        }
        this.widthScale = d1;
        this.foliageDensity = d2;
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        this.world = world;
        long l = random.nextLong();
        this.random.setSeed(l);
        this.origin[0] = x;
        this.origin[1] = y;
        this.origin[2] = z;
        if (this.height == 0) {
            this.height = 12 + this.random.nextInt(4);
        }
        if (!this.checkLocation()) {
            return false;
        }
        WorldFeatureTree.onTreeGrown(this.world, this.origin[0], this.origin[1], this.origin[2]);
        this.prepare();
        this.makeFoliage();
        this.makeTrunk();
        this.makeBranches();
        return true;
    }
}

