/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net;

import java.util.HashMap;
import java.util.Map;

public abstract class ChatEmotes {
    private static final Map<String, Character> emotes = new HashMap<String, Character>();

    public static void register(String name, char substitute) {
        emotes.put(":" + name + ":", Character.valueOf(substitute));
    }

    public static String process(String s) {
        for (Map.Entry<String, Character> entry : emotes.entrySet()) {
            s = s.replaceAll(entry.getKey(), entry.getValue().toString());
        }
        return s;
    }

    public static Map<String, Character> getEmotes() {
        return emotes;
    }

    static {
        ChatEmotes.register("skull", '\u2620');
        ChatEmotes.register("smile", '\u263a');
        ChatEmotes.register("smile2", '\u263b');
        ChatEmotes.register("heart", '\u2764');
        ChatEmotes.register("diamond", '\u2666');
        ChatEmotes.register("club", '\u2663');
        ChatEmotes.register("spade", '\u2660');
        ChatEmotes.register("male", '\u2642');
        ChatEmotes.register("female", '\u2640');
        ChatEmotes.register("note", '\u266a');
        ChatEmotes.register("note2", '\u266b');
        ChatEmotes.register("sun", '\u2600');
        ChatEmotes.register("up", '\u2191');
        ChatEmotes.register("down", '\u2193');
        ChatEmotes.register("right", '\u2192');
        ChatEmotes.register("left", '\u2190');
        ChatEmotes.register("cloud", '\u2601');
        ChatEmotes.register("moon", '\u263d');
        ChatEmotes.register("letter", '\u2709');
        ChatEmotes.register("umbrella", '\u2602');
        ChatEmotes.register("snowman", '\u26c4');
        ChatEmotes.register("hourglass", '\u231b');
        ChatEmotes.register("time", '\u231a');
        ChatEmotes.register("flag", '\u2690');
        ChatEmotes.register("electric", '\u26a1');
        ChatEmotes.register("pickaxe", '\u26cf');
        ChatEmotes.register("tick", '\u2714');
        ChatEmotes.register("snowflake", '\u2744');
        ChatEmotes.register("cross", '\u274c');
        ChatEmotes.register("star", '\u2b50');
    }
}

