/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFullyRotatable;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockLogicBoneShale
extends BlockLogicFullyRotatable {
    public BlockLogicBoneShale(Block<?> block, Material material) {
        super(block, material);
    }

    @Override
    public float blockStrength(World world, int x, int y, int z, Side side, Player player) {
        float blockHardness = this.block.getHardness();
        int meta = world.getBlockMetadata(x, y, z);
        Direction direction = BlockLogicFullyRotatable.metaToDirection(meta);
        if (side != direction.getSide()) {
            blockHardness *= 66.6f;
        }
        if (!player.canHarvestBlock(this.block)) {
            return 1.0f / blockHardness / 30.0f;
        }
        return player.getCurrentPlayerStrVsBlock(this.block) / blockHardness / 30.0f;
    }
}

